/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.util;

import com.mojang.authlib.GameProfile;
import eu.pb4.factorytools.api.resourcepack.BaseItemProvider;
import eu.pb4.factorytools.api.util.WorldPointer;
import eu.pb4.polyfactory.util.ModelRenderType;
import eu.pb4.polyfactory.util.inventory.CustomInsertInventory;
import eu.pb4.polyfactory.util.movingitem.ContainerHolder;
import eu.pb4.polyfactory.util.movingitem.MovingItem;
import eu.pb4.polyfactory.util.movingitem.MovingItemConsumer;
import eu.pb4.sgui.api.GuiHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2614;
import net.minecraft.class_2664;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class FactoryUtil {
    public static final List<class_2350> REORDERED_DIRECTIONS = List.of(class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11036, class_2350.field_11033);
    public static final GameProfile GENERIC_PROFILE = new GameProfile(class_156.field_25140, "[PolyFactory]");
    public static final class_243 HALF_BELOW = new class_243(0.0, -0.5, 0.0);
    public static final List<class_2350> HORIZONTAL_DIRECTIONS = List.of(class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039);
    public static final List<class_1304> ARMOR_EQUIPMENT = Arrays.stream(class_1304.values()).filter(x -> x.method_5925() == class_1304.class_1305.field_6178).toList();
    private static final List<Runnable> RUN_NEXT_TICK = new ArrayList<Runnable>();
    private static final class_1792[] COLORED_MODEL_ITEMS = new class_1792[]{class_1802.field_8267, class_1802.field_8577, class_1802.field_8570, class_1802.field_8370, class_1802.field_18138};
    private static final class_1792[] TRANSPARENT_MODEL_ITEMS = new class_1792[]{class_1802.field_8483, class_1802.field_8393, class_1802.field_8243, class_1802.field_8869, class_1802.field_8095, class_1802.field_8340, class_1802.field_8770, class_1802.field_8507, class_1802.field_8363, class_1802.field_8685, class_1802.field_8838, class_1802.field_8126, class_1802.field_8332, class_1802.field_8734, class_1802.field_8636, class_1802.field_8410, class_1802.field_8736, class_1802.field_8761, class_1802.field_8119, class_1802.field_8196, class_1802.field_8703, class_1802.field_8581, class_1802.field_8500, class_1802.field_8871, class_1802.field_8240, class_1802.field_8085, class_1802.field_8739, class_1802.field_8747, class_1802.field_8501, class_1802.field_8656, class_1802.field_8879, class_1802.field_8157};
    private static int coloredModelIndex = 0;
    private static int transparentModelIndex = 0;

    public static class_1792 requestColoredItem() {
        return COLORED_MODEL_ITEMS[coloredModelIndex++ % COLORED_MODEL_ITEMS.length];
    }

    public static class_1792 requestTransparentItem() {
        return TRANSPARENT_MODEL_ITEMS[transparentModelIndex++ % TRANSPARENT_MODEL_ITEMS.length];
    }

    public static class_1792 requestModelBase(ModelRenderType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ModelRenderType.SOLID -> BaseItemProvider.requestModel();
            case ModelRenderType.TRANSPARENT -> FactoryUtil.requestTransparentItem();
            case ModelRenderType.COLORED -> FactoryUtil.requestColoredItem();
        };
    }

    public static void runNextTick(Runnable runnable) {
        RUN_NEXT_TICK.add(runnable);
    }

    public static void register() {
        ServerTickEvents.START_SERVER_TICK.register(FactoryUtil::onTick);
        ServerLifecycleEvents.SERVER_STOPPED.register(FactoryUtil::onServerStopped);
    }

    private static void onServerStopped(MinecraftServer server) {
        RUN_NEXT_TICK.clear();
    }

    private static void onTick(MinecraftServer server) {
        RUN_NEXT_TICK.forEach(Runnable::run);
        RUN_NEXT_TICK.clear();
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)"polyfactory", (String)path);
    }

    public static class_2561 fluidText(long amount) {
        if (amount >= 81000L) {
            long buckets = amount / 81L;
            return class_2561.method_43470((String)(buckets / 1000L + "." + buckets / 10L % 100L + "B"));
        }
        if (amount >= 81L) {
            long buckets = amount / 81L;
            return class_2561.method_43470((String)(buckets + "mB"));
        }
        if (amount != 0L) {
            return class_2561.method_43470((String)(amount + "d"));
        }
        return class_2561.method_43470((String)"0");
    }

    public static void sendVelocityDelta(class_3222 player, class_243 delta) {
        player.field_13987.method_14364((class_2596)new class_2664(player.method_23317(), player.method_23318() - 9999.0, player.method_23321(), 0.0f, List.of(), delta, class_1927.class_4179.field_40878, (class_2394)class_2398.field_11247, (class_2394)class_2398.field_11247, class_7923.field_41172.method_47983((Object)class_3417.field_42593)));
    }

    public static float wrap(float value, float min, float max) {
        if (value > max) {
            return min;
        }
        if (value < min) {
            return max;
        }
        return value;
    }

    public static int wrap(int value, int min, int max) {
        if (value > max) {
            return min;
        }
        if (value < min) {
            return max;
        }
        return value;
    }

    public static class_1799 exchangeStack(class_1799 inputStack, int subtractedAmount, class_1657 player, class_1799 outputStack, boolean creativeOverride) {
        boolean bl = player.method_56992();
        if (creativeOverride && bl) {
            if (!player.method_31548().method_7379(outputStack)) {
                player.method_31548().method_7394(outputStack);
            }
            return inputStack;
        }
        inputStack.method_57008(subtractedAmount, (class_1309)player);
        if (inputStack.method_7960()) {
            return outputStack;
        }
        if (!player.method_31548().method_7394(outputStack)) {
            player.method_7328(outputStack, false);
        }
        return inputStack;
    }

    public static class_1799 exchangeStack(class_1799 inputStack, int subtractedAmount, class_1657 player, class_1799 outputStack) {
        return FactoryUtil.exchangeStack(inputStack, subtractedAmount, player, outputStack, true);
    }

    public static int tryInserting(class_1937 world, class_2338 pos, class_1799 itemStack, class_2350 direction) {
        class_1263 inv = class_2614.method_11250((class_1937)world, (class_2338)pos);
        if (inv != null) {
            return FactoryUtil.tryInsertingInv(inv, itemStack, direction);
        }
        Storage storage = (Storage)ItemStorage.SIDED.find(world, pos, (Object)direction);
        if (storage != null) {
            try (Transaction t = Transaction.openOuter();){
                long x = storage.insert((Object)ItemVariant.of((class_1799)itemStack), (long)itemStack.method_7947(), (TransactionContext)t);
                t.commit();
                itemStack.method_7934((int)x);
                int n = (int)x;
                return n;
            }
        }
        return -1;
    }

    public static int tryInsertingInv(class_1263 inventory, class_1799 itemStack, class_2350 direction) {
        if (inventory instanceof CustomInsertInventory) {
            CustomInsertInventory customInsertInventory = (CustomInsertInventory)inventory;
            return customInsertInventory.insertStack(itemStack, direction);
        }
        if (inventory instanceof class_1278) {
            class_1278 sidedInventory = (class_1278)inventory;
            return FactoryUtil.tryInsertingSided(sidedInventory, itemStack, direction);
        }
        return FactoryUtil.tryInsertingRegular(inventory, itemStack);
    }

    public static MovableResult tryInsertingMovable(ContainerHolder conveyor, class_1937 world, class_2338 conveyorPos, class_2338 targetPos, class_2350 dir, class_2350 selfDir, @Nullable class_6862<class_2248> requiredTag) {
        MovingItem holdStack = conveyor.getContainer();
        if (holdStack == null || holdStack.method_32327().method_7960()) {
            return MovableResult.FAILURE;
        }
        WorldPointer pointer = new WorldPointer(world, targetPos);
        if (requiredTag != null && !pointer.getBlockState().method_26164(requiredTag)) {
            return MovableResult.FAILURE;
        }
        class_2248 class_22482 = pointer.getBlockState().method_26204();
        if (class_22482 instanceof MovingItemConsumer) {
            MovingItemConsumer conveyorInteracting = (MovingItemConsumer)class_22482;
            if (conveyorInteracting.pushItemTo(pointer, selfDir, dir, conveyorPos, conveyor)) {
                return MovableResult.SUCCESS_MOVABLE;
            }
        } else if (FactoryUtil.tryInserting((class_1937)pointer.getWorld(), pointer.getPos(), holdStack.method_32327(), dir) != -1) {
            if (holdStack.method_32327().method_7960()) {
                conveyor.clearContainer();
                return MovableResult.SUCCESS_REGULAR;
            }
            return MovableResult.SUCCESS_REGULAR;
        }
        return MovableResult.FAILURE;
    }

    private static int tryInsertingSided(class_1278 inventory, class_1799 itemStack, class_2350 direction) {
        int[] slots = inventory.method_5494(direction);
        int init = itemStack.method_7947();
        for (int i = 0; i < slots.length; ++i) {
            int maxMove;
            int slot = slots[i];
            if (!inventory.method_5492(slot, itemStack, direction)) continue;
            class_1799 current = inventory.method_5438(slot);
            if (current.method_7960()) {
                maxMove = Math.min(itemStack.method_7947(), inventory.method_5444());
                inventory.method_5447(slot, itemStack.method_46651(maxMove));
                itemStack.method_7934(maxMove);
            } else if (class_1799.method_31577((class_1799)current, (class_1799)itemStack) && (maxMove = Math.min(Math.min(current.method_7914() - current.method_7947(), itemStack.method_7947()), inventory.method_5444())) > 0) {
                current.method_7933(maxMove);
                itemStack.method_7934(maxMove);
            }
            if (!itemStack.method_7960()) continue;
            return init;
        }
        return init - itemStack.method_7947();
    }

    public static int insertBetween(class_1263 inventory, int start, int end, class_1799 itemStack) {
        int size = Math.min(inventory.method_5439(), end);
        int init = itemStack.method_7947();
        for (int i = start; i < size; ++i) {
            int maxMove;
            class_1799 current = inventory.method_5438(i);
            if (current.method_7960()) {
                maxMove = Math.min(itemStack.method_7947(), inventory.method_5444());
                inventory.method_5447(i, itemStack.method_46651(maxMove));
                itemStack.method_7934(maxMove);
            } else if (class_1799.method_31577((class_1799)current, (class_1799)itemStack) && (maxMove = Math.min(Math.min(current.method_7914() - current.method_7947(), itemStack.method_7947()), inventory.method_5444())) > 0) {
                current.method_7933(maxMove);
                itemStack.method_7934(maxMove);
            }
            if (!itemStack.method_7960()) continue;
            return init;
        }
        return init - itemStack.method_7947();
    }

    public static int tryInsertingRegular(class_1263 inventory, class_1799 itemStack) {
        int size = inventory.method_5439();
        int init = itemStack.method_7947();
        for (int i = 0; i < size; ++i) {
            int maxMove;
            class_1799 current = inventory.method_5438(i);
            if (current.method_7960()) {
                maxMove = Math.min(itemStack.method_7947(), inventory.method_5444());
                inventory.method_5447(i, itemStack.method_46651(maxMove));
                itemStack.method_7934(maxMove);
            } else if (class_1799.method_31577((class_1799)current, (class_1799)itemStack) && (maxMove = Math.min(Math.min(current.method_7914() - current.method_7947(), itemStack.method_7947()), inventory.method_5444())) > 0) {
                current.method_7933(maxMove);
                itemStack.method_7934(maxMove);
            }
            if (!itemStack.method_7960()) continue;
            return init;
        }
        return init - itemStack.method_7947();
    }

    public static <T extends Comparable<T>> class_2680 transform(class_2680 input, Function<T, T> transform, class_2769<T> property) {
        return (class_2680)input.method_47968(property, (Comparable)transform.apply(input.method_11654(property)));
    }

    public static class_1657 getClosestPlayer(class_1937 world, class_2338 pos, double distance) {
        return world.method_18459((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, distance, false);
    }

    public static class_2561 asText(class_2350 dir) {
        return class_2561.method_43471((String)("text.polyfactory.direction." + String.valueOf(dir)));
    }

    public static void setSafeVelocity(class_1297 entity, class_243 vec) {
        entity.method_18799(FactoryUtil.safeVelocity(vec));
    }

    public static class_243 safeVelocity(class_243 vec) {
        double l = vec.method_1033();
        if (l > 1028.0) {
            return vec.method_1021(1028.0 / l);
        }
        return vec;
    }

    public static void addSafeVelocity(class_1297 entity, class_243 vec) {
        FactoryUtil.setSafeVelocity(entity, entity.method_18798().method_1019(vec));
    }

    public static class_2338 findFurthestFluidBlockForRemoval(class_1937 world, class_2680 target, class_2338 start) {
        return start;
    }

    public static class_2338 findFurthestFluidBlockForPlacement(class_2680 target, class_2338 start) {
        return start;
    }

    public static Consumer<class_1799> getItemConsumer(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return arg_0 -> ((class_1661)player.method_31548()).method_7398(arg_0);
        }
        if (entity instanceof class_1263) {
            class_1263 inventory = (class_1263)entity;
            return stack -> {
                FactoryUtil.tryInsertingRegular(inventory, stack);
                if (!stack.method_7960()) {
                    entity.method_5775(stack);
                }
            };
        }
        return arg_0 -> ((class_1297)entity).method_5775(arg_0);
    }

    public static void sendSlotUpdate(class_1297 entity, class_1268 hand) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            GuiHelpers.sendSlotUpdate((class_3222)player, (int)player.field_7498.field_7763, (int)(hand == class_1268.field_5808 ? 36 + player.method_31548().field_7545 : 45), (class_1799)player.method_5998(hand), (int)player.field_7498.method_37422());
        }
    }

    public static class_2680 rotateAxis(class_2680 state, class_2769<class_2350.class_2351> axis, class_2470 rotation) {
        class_2350.class_2351 a = (class_2350.class_2351)state.method_11654(axis);
        if (a == class_2350.class_2351.field_11052 || rotation == class_2470.field_11467 || rotation == class_2470.field_11464) {
            return state;
        }
        return (class_2680)state.method_11657(axis, (Comparable)(a == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048));
    }

    public static <T extends Comparable<T>> class_2680 rotate(class_2680 state, class_2769<T> north, class_2769<T> south, class_2769<T> east, class_2769<T> west, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11464 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(north, state.method_11654(south))).method_11657(east, state.method_11654(west))).method_11657(south, state.method_11654(north))).method_11657(west, state.method_11654(east));
            case class_2470.field_11465 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(north, state.method_11654(east))).method_11657(east, state.method_11654(south))).method_11657(south, state.method_11654(west))).method_11657(west, state.method_11654(north));
            case class_2470.field_11463 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(north, state.method_11654(west))).method_11657(east, state.method_11654(north))).method_11657(south, state.method_11654(east))).method_11657(west, state.method_11654(south));
            default -> state;
        };
    }

    public static <T extends Comparable<T>> class_2680 mirror(class_2680 state, class_2769<T> north, class_2769<T> south, class_2769<T> east, class_2769<T> west, class_2415 mirror) {
        return switch (mirror) {
            case class_2415.field_11300 -> (class_2680)((class_2680)state.method_11657(north, state.method_11654(south))).method_11657(south, state.method_11654(north));
            case class_2415.field_11301 -> (class_2680)((class_2680)state.method_11657(east, state.method_11654(west))).method_11657(west, state.method_11654(east));
            default -> state;
        };
    }

    public static enum MovableResult {
        SUCCESS_MOVABLE,
        SUCCESS_REGULAR,
        FAILURE;

    }
}

