/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.equipmentcompare.config;

import com.anthonyhilyard.iceberg.config.IcebergConfig;
import com.anthonyhilyard.iceberg.services.IIcebergConfigSpecBuilder;
import com.anthonyhilyard.iceberg.util.Selectors;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_7225;

public class EquipmentCompareConfig
extends IcebergConfig<EquipmentCompareConfig> {
    public final Supplier<Boolean> defaultOn;
    public final Supplier<Boolean> strict;
    public final Supplier<Integer> maxComparisons;
    public final Supplier<Long> badgeBackgroundColor;
    public final Supplier<Long> badgeBorderStartColor;
    public final Supplier<Long> badgeBorderEndColor;
    public final Supplier<Boolean> overrideBadgeText;
    public final Supplier<String> badgeText;
    public final Supplier<Long> badgeTextColor;
    private final Supplier<List<? extends String>> blacklist;

    public static EquipmentCompareConfig getInstance() {
        return (EquipmentCompareConfig)((Object)configInstances.get("equipmentcompare"));
    }

    public EquipmentCompareConfig(IIcebergConfigSpecBuilder build) {
        build.comment("Client Configuration").push("client").push("visual_options");
        this.maxComparisons = build.comment(" The maximum number of comparison tooltips to show onscreen at once.").addInRange("max_comparisons", 3, 1, 10);
        this.overrideBadgeText = build.comment(" If badge_text should override the built-in translatable text.").add("override_badge_text", false);
        this.badgeText = build.comment(" The text shown on the badge above equipped tooltips.").add("badge_text", (Object)"Equipped");
        this.badgeTextColor = build.comment(" The color of the text shown on the badge above equipped tooltips.").addInRange("badge_text_color", 0xFFFFFFFFL, 0L, 0xFFFFFFFFL);
        this.badgeBackgroundColor = build.comment(" The background color of the \"equipped\" badge.").addInRange("badge_bg", 0xF0101000L, 0L, 0xFFFFFFFFL);
        this.badgeBorderStartColor = build.comment(" The start border color of the \"equipped\" badge.").addInRange("badge_border_start", 3500839187L, 0L, 0xFFFFFFFFL);
        this.badgeBorderEndColor = build.comment(" The end border color of the \"equipped\" badge.").addInRange("badge_border_end", 1623360778L, 0L, 0xFFFFFFFFL);
        build.pop().push("control_options");
        this.defaultOn = build.comment(" If the comparison tooltip should show by default (pressing bound key hides).").add("default_on", false);
        this.strict = build.comment(" If tool comparisons should compare only the same types of tools (can't compare a sword to an axe, for example).").add("strict", false);
        this.blacklist = build.comment(" Item blacklist to disable comparisons for.  Add to prevent items from being compared when hovered over or equipped.  All Iceberg item selectors are supported (https://github.com/AHilyard/Iceberg/wiki/Item-Selectors-Documentation).").addListAllowEmpty("blacklist", (List)Lists.newArrayList(), e -> Selectors.validateSelector((String)((String)e)));
        build.pop().pop();
    }

    public static boolean isItemBlacklisted(class_1799 itemStack, class_7225.class_7874 provider) {
        for (String string : EquipmentCompareConfig.getInstance().blacklist.get()) {
            if (!Selectors.itemMatches((class_1799)itemStack, (String)string, (class_7225.class_7874)provider)) continue;
            return true;
        }
        return false;
    }
}

