/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.equipmentcompare.gui;

import com.anthonyhilyard.equipmentcompare.EquipmentCompare;
import com.anthonyhilyard.equipmentcompare.config.EquipmentCompareConfig;
import com.anthonyhilyard.iceberg.events.client.RenderTooltipEvents;
import com.anthonyhilyard.iceberg.services.Services;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.iceberg.util.ItemUtil;
import com.anthonyhilyard.iceberg.util.Tooltips;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_7225;
import net.minecraft.class_768;
import net.minecraft.class_8000;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joml.Matrix4f;

public class ComparisonTooltips {
    private static final int DEFAULT_BACKGROUND_COLOR = -267386864;
    private static final int DEFAULT_BORDER_COLOR_START = 0x505000FF;
    private static final int DEFAULT_BORDER_COLOR_END = 1344798847;

    private static class_5250 getEquippedBadge() {
        class_5250 equippedBadge = EquipmentCompareConfig.getInstance().overrideBadgeText.get() != false ? class_2561.method_43471((String)EquipmentCompareConfig.getInstance().badgeText.get()) : class_2561.method_43471((String)"equipmentcompare.general.badgeText");
        return equippedBadge;
    }

    private static void drawTooltip(class_332 graphics, class_8000 positioner, class_1799 itemStack, class_768 rect, List<class_5684> tooltipLines, class_327 font, class_437 screen, int maxWidth, boolean showBadge, boolean centeredTitle, int index) {
        int bgColor = EquipmentCompareConfig.getInstance().badgeBackgroundColor.get().intValue();
        int borderStartColor = EquipmentCompareConfig.getInstance().badgeBorderStartColor.get().intValue();
        int borderEndColor = EquipmentCompareConfig.getInstance().badgeBorderEndColor.get().intValue();
        class_2583 textColor = class_2583.field_24360.method_27703(class_5251.method_27717((int)EquipmentCompareConfig.getInstance().badgeTextColor.get().intValue()));
        class_5250 equippedBadge = ComparisonTooltips.getEquippedBadge().method_27696(textColor);
        boolean constrainToRect = false;
        class_4587 poseStack = graphics.method_51448();
        if (showBadge) {
            if (rect.method_3322() + rect.method_3320() + 4 > screen.field_22790) {
                rect = new class_768(rect.method_3321(), screen.field_22790 - rect.method_3320() - 4, rect.method_3319(), rect.method_3320());
            }
            poseStack.method_22903();
            poseStack.method_46416((float)rect.method_3321(), (float)rect.method_3322(), 401.0f);
            Matrix4f matrix = poseStack.method_23760().method_23761();
            int badgeOffset = 0;
            if (Services.getPlatformHelper().isModLoaded("legendarytooltips")) {
                bgColor = -267386864;
                RenderTooltipEvents.ColorExtResult colorResult = ((RenderTooltipEvents.ColorExt)RenderTooltipEvents.COLOREXT.invoker()).onColor(itemStack, graphics, rect.method_3321(), rect.method_3322(), font, bgColor, bgColor, borderStartColor, borderEndColor, tooltipLines, showBadge, index);
                if (colorResult != null) {
                    bgColor = colorResult.backgroundStart();
                }
                constrainToRect = true;
                badgeOffset = 6;
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)1, (int)(-17 + badgeOffset), (int)(rect.method_3319() + 7), (int)(-16 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)0, (int)(-16 + badgeOffset), (int)1, (int)(-5 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.method_3319() + 7), (int)(-16 + badgeOffset), (int)(rect.method_3319() + 8), (int)(-5 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)1, (int)(-16 + badgeOffset), (int)(rect.method_3319() + 7), (int)(-6 + badgeOffset), (int)bgColor, (int)bgColor);
            } else {
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)1, (int)(-17 + badgeOffset), (int)(rect.method_3319() + 7), (int)(-16 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)0, (int)(-16 + badgeOffset), (int)1, (int)(-4 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.method_3319() + 7), (int)(-16 + badgeOffset), (int)(rect.method_3319() + 8), (int)(-4 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)1, (int)(-4 + badgeOffset), (int)(rect.method_3319() + 7), (int)(-3 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)1, (int)(-16 + badgeOffset), (int)(rect.method_3319() + 7), (int)(-4 + badgeOffset), (int)bgColor, (int)bgColor);
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)1, (int)(-15 + badgeOffset), (int)2, (int)(-5 + badgeOffset), (int)borderStartColor, (int)borderEndColor);
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.method_3319() + 6), (int)(-15 + badgeOffset), (int)(rect.method_3319() + 7), (int)(-5 + badgeOffset), (int)borderStartColor, (int)borderEndColor);
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)1, (int)(-16 + badgeOffset), (int)(rect.method_3319() + 7), (int)(-15 + badgeOffset), (int)borderStartColor, (int)borderStartColor);
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)1, (int)(-5 + badgeOffset), (int)(rect.method_3319() + 7), (int)(-4 + badgeOffset), (int)borderEndColor, (int)borderEndColor);
            }
            graphics.method_27534(font, (class_2561)equippedBadge, rect.method_3319() / 2 + 4, badgeOffset - 14, -1);
            poseStack.method_22909();
        }
        Tooltips.renderItemTooltip((class_1799)itemStack, (Tooltips.TooltipInfo)new Tooltips.TooltipInfo(tooltipLines, font, Tooltips.calculateTitleLines(tooltipLines)), (class_768)rect, (int)screen.field_22789, (int)screen.field_22790, (int)-267386864, (int)-267386864, (int)0x505000FF, (int)1344798847, (class_332)graphics, (class_8000)positioner, (boolean)showBadge, (boolean)constrainToRect, (boolean)centeredTitle, (int)index);
    }

    public static boolean render(class_332 graphics, class_8000 positioner, int x, int y, class_1799 itemStack, class_310 minecraft, class_327 font, class_437 screen) {
        if (screen == null || minecraft == null || minecraft.field_1724 == null || minecraft.field_1724.field_7512 == null || minecraft.field_1687 == null || itemStack == null) {
            return false;
        }
        if (minecraft.field_1724.field_7512.method_34255().method_7960() && !itemStack.method_7960() && !EquipmentCompareConfig.isItemBlacklisted(itemStack, (class_7225.class_7874)minecraft.field_1687.method_30349())) {
            class_1304 slot = ItemUtil.getEquipmentSlot((class_1799)itemStack);
            List equippedItems = new ArrayList<class_1799>();
            class_1799 equippedItem = minecraft.field_1724.method_6118(slot);
            boolean checkItem = true;
            if (slot == class_1304.field_6173) {
                if (!itemStack.method_7963() || !equippedItem.method_7963()) {
                    checkItem = false;
                } else if (EquipmentCompareConfig.getInstance().strict.get().booleanValue() && !itemStack.method_7909().getClass().equals(equippedItem.method_7909().getClass())) {
                    checkItem = false;
                }
            }
            if (checkItem) {
                equippedItems.add(equippedItem);
                equippedItems.remove(class_1799.field_8037);
                equippedItems.remove(itemStack);
            }
            if (Services.getPlatformHelper().isModLoaded("trinkets")) {
                try {
                    equippedItems.addAll((List)Class.forName("com.anthonyhilyard.equipmentcompare.compat.TrinketsHandler").getMethod("getTrinketsMatchingSlot", class_1309.class, class_1799.class).invoke(null, minecraft.field_1724, itemStack));
                }
                catch (Exception e) {
                    EquipmentCompare.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            if (Services.getPlatformHelper().isModLoaded("curios") && Services.getPlatformHelper().getPlatformName().contentEquals("neoforge")) {
                try {
                    equippedItems.addAll((List)Class.forName("com.anthonyhilyard.equipmentcompare.neoforge.compat.CuriosHandler").getMethod("getCuriosMatchingSlot", class_1309.class, class_1799.class).invoke(null, minecraft.field_1724, itemStack));
                }
                catch (Exception e) {
                    EquipmentCompare.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            equippedItems.removeIf(stack -> EquipmentCompareConfig.isItemBlacklisted(stack, (class_7225.class_7874)minecraft.field_1687.method_30349()));
            equippedItems.remove(itemStack);
            if (equippedItems.size() > EquipmentCompareConfig.getInstance().maxComparisons.get()) {
                equippedItems = equippedItems.subList(0, EquipmentCompareConfig.getInstance().maxComparisons.get());
            }
            if (equippedItems.size() > EquipmentCompareConfig.getInstance().maxComparisons.get()) {
                equippedItems = equippedItems.subList(0, EquipmentCompareConfig.getInstance().maxComparisons.get());
            }
            if (!equippedItems.isEmpty() && EquipmentCompare.comparisonsActive ^ EquipmentCompareConfig.getInstance().defaultOn.get()) {
                class_768 equippedRect;
                int maxWidth = (screen.field_22789 - equippedItems.size() * 16) / (equippedItems.size() + 1);
                class_327 itemFont = Services.getFontLookup().getTooltipFont(itemStack, screen);
                if (itemFont == null) {
                    itemFont = font;
                }
                boolean centeredTitle = false;
                boolean enforceMinimumWidth = false;
                if (Services.getPlatformHelper().isModLoaded("legendarytooltips")) {
                    try {
                        centeredTitle = (Boolean)Class.forName("com.anthonyhilyard.equipmentcompare.compat.LegendaryTooltipsHandler").getMethod("getCenteredTitle", new Class[0]).invoke(null, new Object[0]);
                        enforceMinimumWidth = (Boolean)Class.forName("com.anthonyhilyard.equipmentcompare.compat.LegendaryTooltipsHandler").getMethod("getEnforceMinimumWidth", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        EquipmentCompare.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
                List itemStackTooltipLines = Tooltips.gatherTooltipComponents((class_1799)itemStack, (List)class_437.method_25408((class_310)minecraft, (class_1799)itemStack), (Optional)itemStack.method_32347(), (int)x, (int)screen.field_22789, (int)screen.field_22790, (class_327)itemFont, (class_327)font, (int)maxWidth, (int)0);
                class_768 itemStackRect = Tooltips.calculateRect((class_1799)itemStack, (class_332)graphics, (class_8000)positioner, (List)itemStackTooltipLines, (int)x, (int)y, (int)screen.field_22789, (int)screen.field_22790, (int)maxWidth, (class_327)itemFont, (int)(enforceMinimumWidth ? 48 : 0), (boolean)centeredTitle);
                itemStackRect = x + itemStackRect.method_3319() + 12 > screen.field_22789 ? new class_768(screen.field_22789 - itemStackRect.method_3319() - 24, itemStackRect.method_3322(), itemStackRect.method_3319(), itemStackRect.method_3320()) : new class_768(itemStackRect.method_3321() - 2, itemStackRect.method_3322(), itemStackRect.method_3319(), itemStackRect.method_3320());
                HashMap<class_1799, class_768> tooltipRects = new HashMap<class_1799, class_768>();
                HashMap<class_1799, List> tooltipLines = new HashMap<class_1799, List>();
                class_768 previousRect = itemStackRect;
                boolean firstRect = true;
                int tooltipIndex = 1;
                for (class_1799 thisItem : equippedItems) {
                    if (Services.getFontLookup().getTooltipFont(thisItem, screen) != null) {
                        itemFont = Services.getFontLookup().getTooltipFont(thisItem, screen);
                    }
                    List equippedTooltipLines = Tooltips.gatherTooltipComponents((class_1799)thisItem, (List)class_437.method_25408((class_310)minecraft, (class_1799)thisItem), (Optional)thisItem.method_32347(), (int)(x - previousRect.method_3319() - 14), (int)screen.field_22789, (int)screen.field_22790, (class_327)itemFont, (class_327)font, (int)maxWidth, (int)tooltipIndex++);
                    equippedRect = Tooltips.calculateRect((class_1799)itemStack, (class_332)graphics, (class_8000)positioner, (List)equippedTooltipLines, (int)(x - previousRect.method_3319() - 14), (int)y, (int)screen.field_22789, (int)screen.field_22790, (int)maxWidth, (class_327)itemFont, (int)(enforceMinimumWidth ? 48 : 0), (boolean)centeredTitle);
                    class_5250 equippedBadge = ComparisonTooltips.getEquippedBadge();
                    int tooltipWidth = equippedRect.method_3319();
                    equippedRect = new class_768(equippedRect.method_3321(), equippedRect.method_3322(), Math.max(equippedRect.method_3319(), itemFont.method_27525((class_5348)equippedBadge) + 8), equippedRect.method_3320());
                    if (firstRect) {
                        equippedRect = new class_768(previousRect.method_3321() - equippedRect.method_3319() - 16 - (equippedRect.method_3319() - tooltipWidth) / 2, equippedRect.method_3322(), equippedRect.method_3319(), equippedRect.method_3320());
                        firstRect = false;
                    } else {
                        equippedRect = new class_768(previousRect.method_3321() - equippedRect.method_3319() - 12 - (equippedRect.method_3319() - tooltipWidth) / 2, equippedRect.method_3322(), equippedRect.method_3319(), equippedRect.method_3320());
                    }
                    tooltipRects.put(thisItem, equippedRect);
                    tooltipLines.put(thisItem, equippedTooltipLines);
                    previousRect = equippedRect;
                }
                int xOffset = -((class_768)tooltipRects.get(equippedItems.get(equippedItems.size() - 1))).method_3321();
                if (xOffset > 0) {
                    for (class_1799 thisItem : equippedItems) {
                        equippedRect = (class_768)tooltipRects.get(thisItem);
                        tooltipRects.replace(thisItem, new class_768(equippedRect.method_3321() + xOffset, equippedRect.method_3322(), equippedRect.method_3319(), equippedRect.method_3320()));
                    }
                    itemStackRect = new class_768(itemStackRect.method_3321() + xOffset, itemStackRect.method_3322(), itemStackRect.method_3319(), itemStackRect.method_3320());
                }
                tooltipIndex = 1;
                for (class_1799 thisItem : equippedItems) {
                    ComparisonTooltips.drawTooltip(graphics, positioner, thisItem, (class_768)tooltipRects.get(thisItem), (List)tooltipLines.get(thisItem), font, screen, maxWidth, true, centeredTitle, tooltipIndex++);
                }
                ComparisonTooltips.drawTooltip(graphics, positioner, itemStack, itemStackRect, itemStackTooltipLines, font, screen, maxWidth, false, centeredTitle, 0);
                return true;
            }
            return false;
        }
        return false;
    }
}

