/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.tp.manager;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.lopymine.tp.TexturizedParticles;
import net.lopymine.tp.client.TexturizedParticlesClient;
import net.lopymine.tp.particle.TexturizedParticle;
import net.lopymine.tp.utils.ArgbUtils;
import net.lopymine.tp.utils.ListUtils;
import net.lopymine.tp.utils.StatusEffectUtils;
import net.lopymine.tp.utils.TPStatusEffect;
import net.lopymine.tp.utils.TPType;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_703;
import net.minecraft.class_761;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class TexturizedParticleManager {
    private static final List<class_2394> REGISTERED_PARTICLE_TYPES = new ArrayList<class_2394>();
    private static final Map<Integer, List<class_2394>> COLOR_TO_PARTICLES_MAP = new HashMap<Integer, List<class_2394>>();
    private static final HashMap<class_2394, class_1291> MINECRAFT_EFFECTS_WITH_TEXTURIZED_PARTICLE = TexturizedParticleManager.getMinecraftEffectWidthTexturizedParticles();

    @Nullable
    public static List<class_2394> getParticleEffects(Integer i) {
        return COLOR_TO_PARTICLES_MAP.get(i);
    }

    private static class_2394 registerParticleTypeForEffect(class_1291 statusEffect, class_2960 effectId) {
        class_2394 type = (class_2394)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)TexturizedParticleManager.getModEffectId(statusEffect, effectId), (Object)FabricParticleTypes.simple());
        REGISTERED_PARTICLE_TYPES.add(type);
        return type;
    }

    private static class_2960 getModEffectId(class_1291 statusEffect, class_2960 effectId) {
        boolean bl = MINECRAFT_EFFECTS_WITH_TEXTURIZED_PARTICLE.containsValue(statusEffect);
        return TexturizedParticles.id(effectId.method_12832() + (bl ? "_new" : ""));
    }

    public static void onInitialize() {
        class_2960 id;
        class_1291 statusEffect;
        for (class_6880.class_6883 reference : class_7923.field_41174.method_40270().toList()) {
            statusEffect = (class_1291)reference.comp_349();
            id = reference.method_40237().method_29177();
            if (!id.method_12836().equals("minecraft")) continue;
            class_2394 type = TexturizedParticleManager.registerParticleTypeForEffect(statusEffect, id);
            StatusEffectUtils.swapParticle(statusEffect, type);
        }
        for (class_6880.class_6883 reference : class_7923.field_41179.method_40270().toList()) {
            List effects;
            OptionalInt optional;
            class_1842 potion = (class_1842)reference.comp_349();
            id = reference.method_40237().method_29177();
            if (!id.method_12836().equals("minecraft") || (optional = class_1844.method_58111((Iterable)(effects = potion.method_8049()))).isEmpty()) continue;
            int color = ArgbUtils.getColorWithoutAlpha(optional.getAsInt());
            List particleEffects = effects.stream().map(class_1293::method_5579).map(class_6880::comp_349).flatMap(effect -> {
                class_2394 particleEffect = ((TPStatusEffect)effect).texturizedParticles$getParticleEffect();
                if (particleEffect == null) {
                    TexturizedParticlesClient.LOGGER.error("[DEV/Potion Registration] Looks like {} effect with color {} doesn't have textured particle, this shouldn't happen! Skipping it registration.", (Object)color, (Object)effect.method_5560().getString());
                    return Stream.empty();
                }
                return Stream.of(particleEffect);
            }).toList();
            COLOR_TO_PARTICLES_MAP.put(color, particleEffects);
        }
        for (class_6880.class_6883 reference : class_7923.field_41174.method_40270().toList()) {
            statusEffect = (class_1291)reference.comp_349();
            id = reference.method_40237().method_29177();
            if (!id.method_12836().equals("minecraft")) continue;
            int color = ArgbUtils.getColorWithoutAlpha(statusEffect.method_5556());
            class_2394 particleEffect = ((TPStatusEffect)statusEffect).texturizedParticles$getParticleEffect();
            if (particleEffect == null) {
                TexturizedParticlesClient.LOGGER.error("[DEV/Effect Registration] Looks like {} effect with color {} doesn't have textured particle, this shouldn't happen! Skipping it registration.", (Object)color, (Object)statusEffect.method_5560().getString());
                continue;
            }
            List<class_2394> effects = COLOR_TO_PARTICLES_MAP.get(color);
            if (effects != null) {
                TexturizedParticlesClient.LOGGER.warn("[DEV/Effect Registration] Found registered effects for color {} from {} effect, skipping it registration. If you just mod user, ignore it.", (Object)color, (Object)statusEffect.method_5560().getString());
                continue;
            }
            COLOR_TO_PARTICLES_MAP.put(color, List.of(particleEffect));
        }
    }

    public static void onInitializeClient() {
        for (class_2394 type : REGISTERED_PARTICLE_TYPES) {
            ParticleFactoryRegistry.getInstance().register((class_2396)((class_2400)type), TexturizedParticle.BasedFactory::new);
        }
    }

    private static HashMap<class_2394, class_1291> getMinecraftEffectWidthTexturizedParticles() {
        HashMap<class_2394, class_1291> map = new HashMap<class_2394, class_1291>();
        map.put((class_2394)class_2398.field_11246, (class_1291)class_1294.field_50120.comp_349());
        map.put((class_2394)class_2398.field_50246, (class_1291)class_1294.field_50119.comp_349());
        map.put((class_2394)class_2398.field_50245, (class_1291)class_1294.field_50121.comp_349());
        map.put((class_2394)class_2398.field_50251, (class_1291)class_1294.field_50116.comp_349());
        map.put((class_2394)class_2398.field_50250, (class_1291)class_1294.field_50117.comp_349());
        map.put((class_2394)class_2398.field_50252, (class_1291)class_1294.field_50118.comp_349());
        return map;
    }

    public static class_1291 getVanillaStatusEffectByStatusEffect(class_2394 parameters) {
        return MINECRAFT_EFFECTS_WITH_TEXTURIZED_PARTICLE.get(parameters);
    }

    public static void processSplashPotionStageOne(LocalRef<List<class_2394>> localParticleEffects, int color) {
        localParticleEffects.set(null);
        if (!TexturizedParticlesClient.getConfig().isModEnabled()) {
            return;
        }
        List<class_2394> list = TexturizedParticleManager.getParticleEffects(ArgbUtils.getColorWithoutAlpha(color));
        if (list == null) {
            return;
        }
        localParticleEffects.set(list);
    }

    public static class_703 processSplashPotionStageTwo(@Nullable class_1937 world, class_761 instance, class_2394 parameters, boolean alwaysSpawn, double x, double y, double z, double velocityX, double velocityY, double velocityZ, Operation<class_703> original, LocalRef<List<class_2394>> localParticleEffects, int color) {
        if (!TexturizedParticlesClient.getConfig().isModEnabled()) {
            return (class_703)original.call(new Object[]{instance, parameters, alwaysSpawn, x, y, z, velocityX, velocityY, velocityZ});
        }
        List list = (List)localParticleEffects.get();
        if (list == null || world == null) {
            return (class_703)original.call(new Object[]{instance, parameters, alwaysSpawn, x, y, z, velocityX, velocityY, velocityZ});
        }
        class_2394 particleEffect = (class_2394)ListUtils.getRandomElement(list, world.method_8409());
        if (particleEffect == null) {
            return (class_703)original.call(new Object[]{instance, parameters, alwaysSpawn, x, y, z, velocityX, velocityY, velocityZ});
        }
        ((TPType)particleEffect).texturizedParticles$setColor(color);
        return (class_703)original.call(new Object[]{instance, particleEffect, alwaysSpawn, x, y, z, velocityX, velocityY, velocityZ});
    }
}

