/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.tp.modmenu.yacl.simple;

import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.lopymine.tp.modmenu.yacl.simple.SimpleContent;
import net.lopymine.tp.utils.ModMenuUtils;
import net.minecraft.class_2561;

public class SimpleOptionBuilder {
    public static Option.Builder<Boolean> getBooleanOption(String optionId, boolean defValue, Supplier<Boolean> getter, Consumer<Boolean> setter, ValueFormatter<Boolean> formatter, SimpleContent content) {
        return SimpleOptionBuilder.getOption(optionId, defValue, getter, setter, content).controller(o -> BooleanControllerBuilder.create((Option)o).coloured(true).formatValue(formatter));
    }

    public static Option.Builder<Float> getFloatOptionAsSlider(String optionId, float min, float max, float step, float defValue, Supplier<Float> getter, Consumer<Float> setter) {
        return SimpleOptionBuilder.getOption(optionId, Float.valueOf(defValue), getter, setter, SimpleContent.NONE).controller(o -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)o).range((Number)Float.valueOf(min), (Number)Float.valueOf(max))).step((Number)Float.valueOf(step)));
    }

    public static <C> Option.Builder<C> getOption(String optionId, C defValue, Supplier<C> getter, Consumer<C> setter, SimpleContent content) {
        String optionKey = ModMenuUtils.getOptionKey(optionId);
        OptionDescription.Builder descriptionBuilder = OptionDescription.createBuilder().text(new class_2561[]{ModMenuUtils.getDescription(optionKey)});
        if (content == SimpleContent.IMAGE) {
            descriptionBuilder.image(ModMenuUtils.getContentId(content, optionId), 600, 600);
        }
        if (content == SimpleContent.WEBP) {
            descriptionBuilder.webpImage(ModMenuUtils.getContentId(content, optionId));
        }
        return Option.createBuilder().name(ModMenuUtils.getName(optionKey)).description(descriptionBuilder.build()).binding(defValue, getter, setter);
    }

    public Option<?>[] collect(Option<?> ... options) {
        return options;
    }

    public <T> Option<T> getIf(Option<T> option, BooleanSupplier condition) {
        if (condition.getAsBoolean()) {
            return option;
        }
        return null;
    }
}

