/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3111;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BlockAnchorTreeVine;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.feature.api.features.GrowableFeature;

public class AnchorTreeBranchFeature
extends ContextFeature<class_3111>
implements GrowableFeature<class_3111> {
    private static final float[] CURVE_X = new float[]{9.0f, 7.0f, 1.5f, 0.5f, 3.0f, 7.0f};
    private static final float[] CURVE_Y = new float[]{-20.0f, -17.0f, -12.0f, -4.0f, 0.0f, 2.0f};
    private static final int MIDDLE_Y = 10;

    public AnchorTreeBranchFeature() {
        super(class_3111.field_24893);
    }

    @Override
    protected boolean place(class_5425 world, class_2338 pos, class_5819 random, class_3111 config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        float scale_factor = (float)MAX_HEIGHT / 128.0f;
        if (pos.method_10264() < 56 + random.method_43048((int)(20.0f * scale_factor))) {
            return false;
        }
        return this.grow(world, pos, random, scale_factor, context);
    }

    private boolean grow(class_5425 world, class_2338 pos, class_5819 random, float scale_factor, StructureGeneratorThreadContext context) {
        int i;
        context.clear();
        world.method_8652(pos, class_2246.field_10124.method_9564(), 0);
        float scale = MHelper.randRange(0.5f, 1.0f, random);
        int minCount = (double)scale < 0.75 ? 3 : 4;
        int maxCount = (double)scale < 0.75 ? 5 : 7;
        int count = MHelper.randRange(minCount, maxCount, random);
        class_2680 leaves = (class_2680)NetherBlocks.ANCHOR_TREE_LEAVES.method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(true));
        class_2350[] directions = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11033, class_2350.field_11036};
        for (int n = 0; n < count; ++n) {
            float branchSize = MHelper.randRange(0.5f, 0.8f, random) * scale;
            float angle = (float)n * ((float)Math.PI * 2) / (float)count;
            float radius = CURVE_X[0] * branchSize * scale_factor;
            int x1 = Math.round((float)pos.method_10263() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int y1 = Math.round((float)pos.method_10264() + CURVE_Y[0] * branchSize + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int z1 = Math.round((float)pos.method_10260() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            float crownR = 9.0f * branchSize;
            if (crownR < 1.5f) {
                crownR = 1.5f;
            }
            this.crown((class_1936)world, new class_2338(x1, y1 + 1, z1), crownR, random, scale_factor, context);
            int middle = Math.round((float)pos.method_10264() + (float)(10 + MHelper.randRange(-2, 2, random)) * branchSize);
            boolean generate = true;
            for (i = 1; i < CURVE_X.length && generate; ++i) {
                radius = CURVE_X[i] * branchSize;
                int x2 = Math.round((float)pos.method_10263() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                int y2 = Math.round((float)pos.method_10264() + CURVE_Y[i] * branchSize + (CURVE_Y[i] > 0.0f ? MHelper.randRange(-2.0f, 2.0f, random) * branchSize : 0.0f));
                int z2 = Math.round((float)pos.method_10260() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                if (CURVE_Y[i] >= 0.0f && this.canReplace(world.method_8320((class_2338)context.POS.method_10103(x2, y2, z2)))) {
                    boolean noGround = true;
                    for (int d = 1; d < 3; ++d) {
                        if (this.canReplace(world.method_8320((class_2338)context.POS.method_10103(x2, y2 - d, z2)))) continue;
                        y2 -= d;
                        noGround = false;
                        break;
                    }
                    if (noGround) {
                        x2 = pos.method_10263();
                        y2 = pos.method_10264();
                        generate = false;
                    }
                }
                this.line((class_1936)world, x1, y1, z1, x2, y2, z2, middle, context);
                x1 = x2;
                y1 = y2;
                z1 = z2;
            }
        }
        Iterator<class_2338> iterator = context.TOP.iterator();
        while (iterator.hasNext()) {
            class_2338 bpos = iterator.next();
            if (bpos == null || !context.POINTS.contains(bpos.method_10084()) || context.TOP.contains(bpos.method_10084())) continue;
            iterator.remove();
        }
        iterator = context.MIDDLE.iterator();
        while (iterator.hasNext()) {
            class_2338 bpos = iterator.next();
            if (bpos != null) {
                class_2338 up = bpos.method_10084();
                if (!context.MIDDLE.contains(up) && (context.TOP.contains(up) || !context.POINTS.contains(up))) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        for (class_2338 bpos : context.POINTS) {
            class_2680 state = context.POINTS.contains(bpos.method_10084()) && context.POINTS.contains(bpos.method_10074()) ? NetherBlocks.MAT_ANCHOR_TREE.getLog().method_9564() : NetherBlocks.MAT_ANCHOR_TREE.getBark().method_9564();
            BlocksHelper.setWithUpdate((class_1936)world, bpos, state);
            boolean hasLeavesOnLevel = false;
            for (class_2350 d : directions) {
                class_2680 currentState;
                if (!hasLeavesOnLevel && d == class_2350.field_11033) continue;
                int max = 0;
                for (i = 1; i <= 7; ++i) {
                    context.POS.method_25504((class_2382)bpos, d.method_10148() * i, d.method_10164() * i, d.method_10165() * i);
                    currentState = world.method_8320((class_2338)context.POS);
                    if (!currentState.method_28498((class_2769)class_2741.field_12541)) continue;
                    max = i;
                }
                if (d != class_2350.field_11033 && d != class_2350.field_11036) {
                    hasLeavesOnLevel |= max > 0;
                }
                for (i = 1; i < max; ++i) {
                    context.POS.method_25504((class_2382)bpos, d.method_10148() * i, d.method_10164() * i, d.method_10165() * i);
                    currentState = world.method_8320((class_2338)context.POS);
                    if (!currentState.method_27852(NetherBlocks.ANCHOR_TREE_VINE) && !currentState.method_27852(class_2246.field_10124)) continue;
                    BlocksHelper.setWithUpdate((class_1936)world, (class_2338)context.POS, leaves);
                    class_2338 vpos = context.POS.method_10084();
                    currentState = world.method_8320(vpos);
                    while (currentState.method_27852(NetherBlocks.ANCHOR_TREE_VINE)) {
                        AnchorTreeBranchFeature.safeSet((class_1936)world, vpos, leaves);
                        vpos = vpos.method_10084();
                        currentState = world.method_8320(vpos);
                    }
                }
            }
            this.updateSDFFrom(bpos, context);
        }
        context.clear();
        this.updateDistances(world, context);
        context.LOGS_DIST.clear();
        return true;
    }

    public static void safeSet(class_1936 level, class_2338 pos, class_2680 state) {
        if (!state.method_27852(class_2246.field_9987)) {
            BlocksHelper.setWithoutUpdate(level, pos, state);
        }
    }

    private void updateDistances(class_5425 world, StructureGeneratorThreadContext context) {
        for (Map.Entry<class_2338, Byte> entry : context.LOGS_DIST.entrySet()) {
            byte dist = entry.getValue();
            class_2338 logPos = entry.getKey();
            class_2680 currentState = world.method_8320(logPos);
            if (!currentState.method_28498((class_2769)class_2741.field_12541)) continue;
            int cDist = (Integer)currentState.method_11654((class_2769)class_2741.field_12541);
            if (dist < cDist) {
                AnchorTreeBranchFeature.safeSet((class_1936)world, logPos, (class_2680)currentState.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(dist)));
                cDist = dist;
            }
            if (cDist < 7) continue;
            AnchorTreeBranchFeature.safeSet((class_1936)world, logPos, class_2246.field_10124.method_9564());
            class_2338 pos = logPos.method_10074();
            currentState = world.method_8320(pos);
            while (currentState.method_27852(NetherBlocks.ANCHOR_TREE_VINE)) {
                AnchorTreeBranchFeature.safeSet((class_1936)world, pos, class_2246.field_10124.method_9564());
                pos = pos.method_10074();
                currentState = world.method_8320(pos);
            }
        }
    }

    private void updateSDFFrom(class_2338 bpos, StructureGeneratorThreadContext context) {
        for (int x = -7; x <= 7; ++x) {
            for (int y = -7; y <= 7; ++y) {
                for (int z = -7; z <= 7; ++z) {
                    int dist;
                    if (x == 0 && y == 0 && z == 0 || (dist = Math.abs(x) + Math.abs(y) + Math.abs(z)) > 7) continue;
                    class_2338 blPos = bpos.method_10069(x, y, z);
                    context.LOGS_DIST.merge(blPos, (byte)dist, (oldDist, newDist) -> (byte)Math.min(oldDist.byteValue(), dist));
                }
            }
        }
    }

    private void line(class_1936 world, int x1, int y1, int z1, int x2, int y2, int z2, int middleY, StructureGeneratorThreadContext context) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int mx = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        float fdx = (float)dx / (float)mx;
        float fdy = (float)dy / (float)mx;
        float fdz = (float)dz / (float)mx;
        float px = x1;
        float py = y1;
        float pz = z1;
        class_2338 pos = context.POS.method_10103(x1, y1, z1).method_10062();
        context.POINTS.add(pos);
        if (pos.method_10264() == middleY) {
            context.MIDDLE.add(pos);
        } else if (pos.method_10264() > middleY) {
            context.TOP.add(pos);
        }
        pos = context.POS.method_10103(x2, y2, z2).method_10062();
        context.POINTS.add(pos);
        if (pos.method_10264() == middleY) {
            context.MIDDLE.add(pos);
        } else if (pos.method_10264() > middleY) {
            context.TOP.add(pos);
        }
        for (int i = 0; i < mx; ++i) {
            context.POS.method_10103(Math.round(px += fdx), Math.round(py += fdy), Math.round(pz += fdz));
            pos = context.POS.method_10062();
            context.POINTS.add(pos);
            if (context.POS.method_10264() == middleY) {
                context.MIDDLE.add(pos);
                continue;
            }
            if (context.POS.method_10264() <= middleY) continue;
            context.TOP.add(pos);
        }
    }

    private void crown(class_1936 world, class_2338 pos, float radius, class_5819 random, float scale_factor, StructureGeneratorThreadContext context) {
        scale_factor = (scale_factor - 1.0f) * 0.25f + 1.0f;
        float rnd = MHelper.nextFloat(random, 5.0f * scale_factor);
        int HEIGHT_10 = (int)(10.0f * scale_factor + rnd);
        int HEIGHT_15 = (int)(15.0f * scale_factor + rnd);
        int HEIGHT_17 = (int)(17.0f * scale_factor + rnd);
        class_2680 leaves = NetherBlocks.ANCHOR_TREE_LEAVES.method_9564();
        class_2680 vine = NetherBlocks.ANCHOR_TREE_VINE.method_9564();
        float halfR = radius * 0.5f;
        float r2 = radius * radius;
        int start = (int)Math.floor(-radius);
        for (int cy = (int)Math.floor(radius); cy >= start; --cy) {
            int cy2_out = cy * cy;
            float cy2_in = (float)cy + halfR;
            cy2_in *= cy2_in;
            context.POS.method_33098((int)((float)(pos.method_10264() + cy) - halfR));
            int cx = start;
            while ((float)cx <= radius) {
                int cx2 = cx * cx;
                context.POS.method_33097(pos.method_10263() + cx);
                int cz = start;
                while ((float)cz <= radius) {
                    int cz2 = cz * cz;
                    if ((float)(cx2 + cy2_out + cz2) < r2 && (float)cx2 + cy2_in + (float)cz2 > r2) {
                        context.POS.method_33099(pos.method_10260() + cz);
                        if (world.method_8320((class_2338)context.POS).method_45474()) {
                            int length = BlocksHelper.downRay(world, (class_2338)context.POS, HEIGHT_17);
                            if (length < 5) {
                                AnchorTreeBranchFeature.safeSet(world, (class_2338)context.POS, leaves);
                            } else {
                                if (length > HEIGHT_15) {
                                    length = MHelper.randRange(HEIGHT_10, HEIGHT_15, random);
                                } else if (length > HEIGHT_10) {
                                    length = MHelper.randRange(HEIGHT_10, length, random);
                                }
                                if (cz % 2 == cx % 2) {
                                    length /= 3;
                                }
                                if (length > 4) {
                                    for (int i = 1; i < length - 2; ++i) {
                                        AnchorTreeBranchFeature.safeSet(world, context.POS.method_10087(i), vine);
                                    }
                                    AnchorTreeBranchFeature.safeSet(world, context.POS.method_10087(length - 2), (class_2680)vine.method_11657(BlockAnchorTreeVine.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE));
                                    AnchorTreeBranchFeature.safeSet(world, context.POS.method_10087(length - 1), (class_2680)vine.method_11657(BlockAnchorTreeVine.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
                                }
                                AnchorTreeBranchFeature.safeSet(world, (class_2338)context.POS, leaves);
                            }
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
        }
    }

    private boolean canReplace(class_2680 state) {
        return BlocksHelper.isNetherGround(state) || state.method_45474();
    }

    public boolean grow(class_5425 level, class_2338 pos, class_5819 random, class_3111 cfg) {
        return this.grow(level, pos, random, 1.0f, NetherThreadDataStorage.generatorForThread().context);
    }
}

