/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.accessor.WorldRendererAccessor;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import dev.lambdaurora.lambdynlights.api.DynamicLightsInitializer;
import dev.lambdaurora.lambdynlights.engine.DynamicLightingEngine;
import dev.lambdaurora.lambdynlights.resource.item.ItemLightSources;
import dev.yumi.commons.event.EventManager;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambDynLights
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights");
    public static final EventManager<class_2960> EVENT_MANAGER = new EventManager<class_2960>(class_2960.method_60655((String)"lambdynlights", (String)"default"), class_2960::method_60654);
    private static LambDynLights INSTANCE;
    public final DynamicLightsConfig config = new DynamicLightsConfig(this);
    public final ItemLightSources itemLightSources = new ItemLightSources();
    private final DynamicLightingEngine engine = new DynamicLightingEngine();
    private final Set<DynamicLightSource> dynamicLightSources = new HashSet<DynamicLightSource>();
    private final List<DynamicLightSource> toClear = new ArrayList<DynamicLightSource>();
    private final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    private long lastUpdate = System.currentTimeMillis();
    private int lastUpdateCount = 0;

    public void onInitializeClient() {
        INSTANCE = this;
        LambDynLights.log(LOGGER, "Initializing LambDynamicLights...");
        this.config.load();
        FabricLoader.getInstance().getEntrypointContainers("dynamiclights", DynamicLightsInitializer.class).stream().map(EntrypointContainer::getEntrypoint).forEach(initializer -> initializer.onInitializeDynamicLights(this.itemLightSources));
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this.itemLightSources);
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> this.itemLightSources.apply(registries));
        ClientTickEvents.END_WORLD_TICK.register(level -> {
            this.lightSourcesLock.writeLock().lock();
            this.engine.computeSpatialLookup(this.dynamicLightSources);
            this.toClear.forEach(source -> source.lambdynlights$scheduleTrackedChunksRebuild(class_310.method_1551().field_1769));
            this.toClear.clear();
            this.lightSourcesLock.writeLock().unlock();
        });
        WorldRenderEvents.START.register(context -> {
            class_310.method_1551().method_16011().method_15405("dynamic_lighting");
            this.updateAll(context.worldRenderer());
        });
        DynamicLightHandlers.registerDefaultHandlers();
    }

    public void updateAll(@NotNull class_761 renderer) {
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now >= this.lastUpdate + 50L) {
            this.lastUpdate = now;
            this.lastUpdateCount = 0;
            for (DynamicLightSource lightSource : this.dynamicLightSources) {
                if (!lightSource.lambdynlights$updateDynamicLight(renderer)) continue;
                ++this.lastUpdateCount;
            }
        }
    }

    public int getLastUpdateCount() {
        return this.lastUpdateCount;
    }

    public int getLightmapWithDynamicLight(@NotNull class_1920 level, @NotNull class_2338 pos, int lightmap) {
        return this.getLightmapWithDynamicLight(this.getDynamicLightLevel(pos), lightmap);
    }

    public int getLightmapWithDynamicLight(@NotNull class_1297 entity, int lightmap) {
        int posLightLevel = (int)this.getDynamicLightLevel(entity.method_23312());
        int entityLuminance = ((DynamicLightSource)entity).getLuminance();
        return this.getLightmapWithDynamicLight(Math.max(posLightLevel, entityLuminance), lightmap);
    }

    public int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = class_765.method_24186((int)lightmap))) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public double getDynamicLightLevel(@NotNull class_2338 pos) {
        this.lightSourcesLock.readLock().lock();
        double light = this.engine.getDynamicLightLevel(pos);
        this.lightSourcesLock.readLock().unlock();
        return light;
    }

    public void addLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.getDynamicLightLevel().method_8608()) {
            return;
        }
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return;
        }
        if (this.containsLightSource(lightSource)) {
            return;
        }
        this.dynamicLightSources.add(lightSource);
    }

    public boolean containsLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.getDynamicLightLevel().method_8608()) {
            return false;
        }
        return this.dynamicLightSources.contains(lightSource);
    }

    public int getLightSourcesCount() {
        return this.dynamicLightSources.size();
    }

    public void removeLightSource(@NotNull DynamicLightSource lightSource) {
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!it.equals(lightSource)) continue;
            dynamicLightSources.remove();
            this.toClear.add(lightSource);
            break;
        }
    }

    public void clearLightSources() {
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            dynamicLightSources.remove();
            if (it.getLuminance() > 0) {
                it.resetDynamicLight();
            }
            this.toClear.add(it);
        }
    }

    public void removeLightSources(@NotNull Predicate<DynamicLightSource> filter) {
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!filter.test(it)) continue;
            dynamicLightSources.remove();
            if (it.getLuminance() > 0) {
                it.resetDynamicLight();
            }
            this.toClear.add(it);
            break;
        }
    }

    public void removeEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof class_1297 && !(lightSource instanceof class_1657));
    }

    public void removeCreeperLightSources() {
        this.removeLightSources(entity -> entity instanceof class_1548);
    }

    public void removeTntLightSources() {
        this.removeLightSources(entity -> entity instanceof class_1541);
    }

    public static void log(Logger logger, String msg) {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.info((String)msg);
    }

    public static void warn(Logger logger, String msg) {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.warn((String)msg);
    }

    public static void warn(Logger logger, String msg, Object ... args) {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.warn((String)msg, args);
    }

    public static void scheduleChunkRebuild(@NotNull class_761 renderer, @NotNull class_2338 chunkPos) {
        LambDynLights.scheduleChunkRebuild(renderer, chunkPos.method_10263(), chunkPos.method_10264(), chunkPos.method_10260());
    }

    public static void scheduleChunkRebuild(@NotNull class_761 renderer, long chunkPos) {
        LambDynLights.scheduleChunkRebuild(renderer, class_2338.method_10061((long)chunkPos), class_2338.method_10071((long)chunkPos), class_2338.method_10083((long)chunkPos));
    }

    public static void scheduleChunkRebuild(@NotNull class_761 renderer, int x, int y, int z) {
        if (class_310.method_1551().field_1687 != null) {
            ((WorldRendererAccessor)renderer).lambdynlights$scheduleChunkRebuild(x, y, z, false);
        }
    }

    public static void updateTrackedChunks(@NotNull class_2338 chunkPos, @Nullable LongOpenHashSet old, @Nullable LongOpenHashSet newPos) {
        if (old != null || newPos != null) {
            long pos = chunkPos.method_10063();
            if (old != null) {
                old.remove(pos);
            }
            if (newPos != null) {
                newPos.add(pos);
            }
        }
    }

    public static void updateTracking(@NotNull DynamicLightSource lightSource) {
        boolean enabled = lightSource.isDynamicLightEnabled();
        int luminance = lightSource.getLuminance();
        if (!enabled && luminance > 0) {
            lightSource.setDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.setDynamicLightEnabled(false);
        }
    }

    private static boolean isEyeSubmergedInFluid(class_1309 entity) {
        if (!((Boolean)LambDynLights.get().config.getWaterSensitiveCheck().get()).booleanValue()) {
            return false;
        }
        class_2338 eyePos = class_2338.method_49637((double)entity.method_23317(), (double)entity.method_23320(), (double)entity.method_23321());
        return !entity.method_37908().method_8316(eyePos).method_15769();
    }

    public static int getLivingEntityLuminanceFromItems(class_1309 entity) {
        boolean submergedInFluid = LambDynLights.isEyeSubmergedInFluid(entity);
        int luminance = 0;
        for (class_1799 equipped : entity.method_56675()) {
            if (equipped.method_7960()) continue;
            luminance = Math.max(luminance, LambDynLights.getLuminanceFromItemStack(equipped, submergedInFluid));
        }
        return luminance;
    }

    public static int getLuminanceFromItemStack(@NotNull class_1799 stack, boolean submergedInWater) {
        return LambDynLights.INSTANCE.itemLightSources.getLuminance(stack, submergedInWater);
    }

    public static LambDynLights get() {
        return INSTANCE;
    }
}

