/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.badge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.github.apace100.apoli.integration.PostPowerLoadCallback;
import io.github.apace100.apoli.integration.PowerOverrideCallback;
import io.github.apace100.apoli.integration.PrePowerReloadCallback;
import io.github.apace100.apoli.power.MultiplePower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerManager;
import io.github.apace100.apoli.power.type.Active;
import io.github.apace100.apoli.power.type.PowerType;
import io.github.apace100.apoli.power.type.RecipePowerType;
import io.github.apace100.apoli.power.type.ToggleNightVisionPowerType;
import io.github.apace100.apoli.power.type.TogglePowerType;
import io.github.apace100.calio.registry.DataObjectFactory;
import io.github.apace100.calio.registry.DataObjectRegistry;
import io.github.apace100.calio.util.DynamicIdentifier;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeFactories;
import io.github.apace100.origins.badge.BadgeFactory;
import io.github.apace100.origins.badge.CraftingRecipeBadge;
import io.github.apace100.origins.badge.KeybindBadge;
import io.github.apace100.origins.integration.AutoBadgeCallback;
import io.github.apace100.origins.networking.packet.s2c.SyncBadgeRegistryS2CPacket;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_8710;
import net.minecraft.class_8786;

public final class BadgeManager {
    public static final DataObjectRegistry<Badge> REGISTRY = new DataObjectRegistry.Builder(Origins.identifier("badge"), Badge.class).readFromData("badges", true).dataErrorHandler((id, exception) -> Origins.LOGGER.error("Failed to read badge " + String.valueOf(id) + ", caused by", (Throwable)exception)).defaultFactory((DataObjectFactory)BadgeFactories.KEYBIND).buildAndRegister();
    public static final class_2960 PHASE = Origins.identifier("phase/badge_manager");
    private static final Map<class_2960, List<Badge>> BADGES = new HashMap<class_2960, List<Badge>>();
    private static final class_2960 TOGGLE_BADGE_SPRITE = Origins.identifier("textures/gui/badge/toggle.png");
    private static final class_2960 ACTIVE_BADGE_SPRITE = Origins.identifier("textures/gui/badge/active.png");
    private static final class_2960 RECIPE_BADGE_SPRITE = Origins.identifier("textures/gui/badge/recipe.png");
    private static final class_2960 TOGGLE_BADGE_ID = Origins.identifier("toggle");
    private static final class_2960 ACTIVE_BADGE_ID = Origins.identifier("active");

    public static void init() {
        BadgeManager.register(BadgeFactories.SPRITE);
        BadgeManager.register(BadgeFactories.TOOLTIP);
        BadgeManager.register(BadgeFactories.CRAFTING_RECIPE);
        BadgeManager.register(BadgeFactories.KEYBIND);
        PrePowerReloadCallback.EVENT.register(BadgeManager::clear);
        PowerManager.registerAdditionalData((String)"badges", BadgeManager::readCustomBadges);
        PowerOverrideCallback.EVENT.register(BADGES::remove);
        PostPowerLoadCallback.EVENT.register(BadgeManager::readAutoBadges);
        AutoBadgeCallback.EVENT.register(BadgeManager::createAutoBadges);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.addPhaseOrdering(PowerManager.PHASE, PHASE);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(PHASE, (player, joined) -> BadgeManager.sync(player));
    }

    public static void sync(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncBadgeRegistryS2CPacket(BADGES));
    }

    public static void register(BadgeFactory factory) {
        REGISTRY.registerFactory(factory.id(), (DataObjectFactory)factory);
    }

    public static void putPowerBadge(class_2960 powerId, Badge badge) {
        BADGES.computeIfAbsent(powerId, id -> new LinkedList()).add(badge);
    }

    public static void putPowerBadges(class_2960 powerId, Collection<Badge> badges) {
        BADGES.computeIfAbsent(powerId, id -> new LinkedList()).addAll(badges);
    }

    public static List<Badge> getPowerBadges(class_2960 powerId) {
        return BADGES.getOrDefault(powerId, List.of());
    }

    public static boolean hasPowerBadges(class_2960 powerId) {
        return BADGES.containsKey(powerId);
    }

    public static boolean hasPowerBadges(Power power) {
        return BadgeManager.hasPowerBadges(power.getId());
    }

    public static void clear() {
        BADGES.clear();
    }

    public static void readCustomBadges(class_2960 powerId, class_2960 factoryId, boolean isSubPower, JsonElement data, Power power) {
        if (power.isHidden() || isSubPower) {
            return;
        }
        try {
            if (!(data instanceof JsonArray)) {
                throw new JsonSyntaxException("\"badges\" should be a JSON array!");
            }
            JsonArray dataArray = (JsonArray)data;
            List badges = BADGES.computeIfAbsent(powerId, id -> new LinkedList());
            for (JsonElement badgeJson : dataArray) {
                Badge badge;
                if (badgeJson instanceof JsonObject) {
                    JsonObject badgeObject = (JsonObject)badgeJson;
                    badge = (Badge)REGISTRY.readDataObject((JsonElement)badgeObject);
                } else if (badgeJson instanceof JsonPrimitive) {
                    JsonPrimitive badgePrimitive = (JsonPrimitive)badgeJson;
                    class_2960 badgeId = DynamicIdentifier.of((JsonElement)badgePrimitive);
                    badge = (Badge)REGISTRY.get(badgeId);
                    if (badge == null) {
                        throw new IllegalArgumentException("Badge \"" + String.valueOf(badgeId) + "\" is undefined");
                    }
                } else {
                    throw new JsonSyntaxException("Nested JSON arrays are not allowed!");
                }
                badges.add(badge);
            }
        }
        catch (Exception e) {
            Origins.LOGGER.error("There was a problem parsing badges of power \"{}\": {}", (Object)powerId, (Object)e.getMessage());
        }
    }

    public static void readAutoBadges(class_2960 powerId, class_2960 factoryId, boolean isSubPower, JsonObject json, Power power) {
        if (!(BadgeManager.hasPowerBadges(powerId) || power instanceof MultiplePower || !isSubPower && power.isHidden())) {
            ((AutoBadgeCallback)AutoBadgeCallback.EVENT.invoker()).createAutoBadge(powerId, power, BADGES.computeIfAbsent(powerId, id -> new LinkedList()));
        }
    }

    public static void createAutoBadges(class_2960 powerId, Power power, List<Badge> badgeList) {
        PowerType powerType = power.create(null);
        if (powerType instanceof Active) {
            class_2960 autoBadgeId;
            Active active = (Active)powerType;
            boolean toggle = active instanceof TogglePowerType || active instanceof ToggleNightVisionPowerType;
            class_2960 class_29602 = autoBadgeId = toggle ? TOGGLE_BADGE_ID : ACTIVE_BADGE_ID;
            if (REGISTRY.containsId(autoBadgeId)) {
                badgeList.add((Badge)REGISTRY.get(autoBadgeId));
            } else {
                class_2960 spriteId = toggle ? TOGGLE_BADGE_SPRITE : ACTIVE_BADGE_SPRITE;
                String key = toggle ? "origins.gui.badge.toggle" : "origins.gui.badge.active";
                badgeList.add(new KeybindBadge(spriteId, key));
            }
        } else if (powerType instanceof RecipePowerType) {
            RecipePowerType recipePowerType = (RecipePowerType)powerType;
            class_8786 entry = recipePowerType.getRecipe();
            class_1860 spriteId = entry.comp_1933();
            if (!(spriteId instanceof class_3955)) {
                return;
            }
            class_3955 craftingRecipe = (class_3955)spriteId;
            String type = craftingRecipe instanceof class_1869 ? "shaped" : "shapeless";
            CraftingRecipeBadge badge = new CraftingRecipeBadge(RECIPE_BADGE_SPRITE, (class_8786<class_3955>)new class_8786(entry.comp_1932(), (class_1860)craftingRecipe), (class_2561)class_2561.method_43471((String)("origins.gui.badge.recipe.crafting." + type)), null);
            badgeList.add(badge);
        }
    }
}

