/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.component;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerManager;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayerManager;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.util.ChoseOriginCriterion;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class PlayerOriginComponent
implements OriginComponent {
    private final Map<OriginLayer, Origin> origins = new ConcurrentHashMap<OriginLayer, Origin>();
    private final class_1657 player;
    private boolean selectingOrigin = false;
    private boolean hadOriginBefore = false;
    private int invulnerabilityTicks = 0;

    public PlayerOriginComponent(class_1657 player) {
        this.player = player;
    }

    @Override
    public boolean hasSelectionInvulnerability() {
        return this.invulnerabilityTicks > 0;
    }

    @Override
    public boolean isSelectingOrigin() {
        return this.selectingOrigin;
    }

    @Override
    public void selectingOrigin(boolean selectingOrigin) {
        this.selectingOrigin = selectingOrigin;
        if (selectingOrigin && !this.player.method_37908().field_9236) {
            this.invulnerabilityTicks = 60;
        }
    }

    @Override
    public boolean hasAllOrigins() {
        return OriginLayerManager.getLayers().stream().allMatch(layer -> !layer.isEnabled() || layer.getOrigins().isEmpty() || layer.getOriginOptionCount(this.player) == 0 || this.hasOrigin((OriginLayer)layer));
    }

    @Override
    public Map<OriginLayer, Origin> getOrigins() {
        return this.origins;
    }

    @Override
    public boolean hasOrigin(OriginLayer layer) {
        return this.origins.containsKey(layer) && this.origins.get(layer) != Origin.EMPTY;
    }

    @Override
    public Origin getOrigin(OriginLayer layer) {
        return this.origins.get(layer);
    }

    @Override
    public boolean hadOriginBefore() {
        return this.hadOriginBefore;
    }

    @Override
    public void removeLayer(OriginLayer layer) {
        Origin oldOrigin = this.getOrigin(layer);
        if (oldOrigin != null) {
            ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player)).removeAllPowersFromSource(oldOrigin.getId());
        }
        this.origins.remove(layer);
    }

    @Override
    public void setOrigin(OriginLayer layer, Origin origin) {
        class_1657 class_16572;
        Origin oldOrigin = this.getOrigin(layer);
        if (origin == oldOrigin) {
            return;
        }
        PowerHolderComponent powerComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player);
        if (oldOrigin != null) {
            if (!oldOrigin.getId().equals((Object)origin.getId())) {
                int removedPowers = powerComponent.removeAllPowersFromSource(oldOrigin.getId());
                if (removedPowers > 0) {
                    PowerHolderComponent.PacketHandlers.REVOKE_ALL_POWERS.sync((class_1297)this.player, List.of(oldOrigin.getId()));
                }
            } else if (!oldOrigin.toJson().equals((Object)origin.toJson())) {
                this.revokeRemovedPowers(origin, powerComponent);
            }
        }
        this.grantPowersFromOrigin(origin);
        this.origins.put(layer, origin);
        if (this.hasAllOrigins()) {
            this.hadOriginBefore = true;
        }
        if ((class_16572 = this.player) instanceof class_3222) {
            class_3222 spe = (class_3222)class_16572;
            ChoseOriginCriterion.INSTANCE.trigger(spe, origin);
        }
    }

    private void grantPowersFromOrigin(Origin origin) {
        PowerHolderComponent.grantPowers((class_1297)this.player, Map.of(origin.getId(), origin.getPowers()), (boolean)true);
    }

    private void revokeRemovedPowers(Origin origin, PowerHolderComponent powerComponent) {
        class_2960 sourceId = origin.getId();
        List<Power> powers = powerComponent.getPowersFromSource(sourceId).stream().filter(Predicate.not(origin::hasPower)).toList();
        boolean revoked = powers.stream().map(pt -> powerComponent.removePower(pt, sourceId)).reduce(false, Boolean::logicalOr);
        if (revoked) {
            PowerHolderComponent.PacketHandlers.REVOKE_POWERS.sync((class_1297)this.player, Map.of(sourceId, powers));
        }
    }

    public void serverTick() {
        if (!this.selectingOrigin && this.invulnerabilityTicks > 0) {
            --this.invulnerabilityTicks;
        }
    }

    public void readFromNbt(@NotNull class_2487 compoundTag, class_7225.class_7874 wrapperLookup) {
        int i;
        if (this.player == null) {
            Origins.LOGGER.error("Player was null in PlayerOriginComponent#fromTag! This is not supposed to happen D:");
            return;
        }
        PowerHolderComponent powerComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player);
        this.origins.clear();
        if (compoundTag.method_10545("Origin")) {
            try {
                OriginLayer defaultOriginLayer = OriginLayerManager.get(Origins.identifier("origin"));
                this.origins.put(defaultOriginLayer, OriginRegistry.get(class_2960.method_60654((String)compoundTag.method_10558("Origin"))));
            }
            catch (Exception ignored) {
                Origins.LOGGER.warn("Player {} had old origin which could not be migrated: {}", (Object)this.player.method_5477().getString(), (Object)compoundTag.method_10558("Origin"));
            }
        } else {
            class_2499 originLayersNbt = compoundTag.method_10554("OriginLayers", 10);
            for (i = 0; i < originLayersNbt.size(); ++i) {
                class_2487 originLayerNbt = originLayersNbt.method_10602(i);
                try {
                    class_2960 layerId = class_2960.method_60654((String)originLayerNbt.method_10558("Layer"));
                    class_2960 originId = class_2960.method_60654((String)originLayerNbt.method_10558("Origin"));
                    OriginLayer layer = OriginLayerManager.get(layerId);
                    Origin origin = OriginRegistry.get(originId);
                    this.origins.put(layer, origin);
                    if (layer.contains(origin) || origin.isSpecial()) continue;
                    Origins.LOGGER.warn("Origin \"{}\" is not in origin layer \"{}\" and is not considered special, but was found on player {}!", (Object)originId, (Object)layerId, (Object)this.player.method_5477().getString());
                    powerComponent.removeAllPowersFromSource(originId);
                    this.origins.put(layer, Origin.EMPTY);
                    continue;
                }
                catch (Exception e) {
                    Origins.LOGGER.error("There was a problem trying to read origin NBT data of player {}: {}", (Object)this.player.method_5477().getString(), (Object)e.getMessage());
                }
            }
        }
        this.selectingOrigin = compoundTag.method_10577("SelectingOrigin");
        this.hadOriginBefore = compoundTag.method_10577("HadOriginBefore");
        if (this.player.method_37908().field_9236) {
            return;
        }
        for (Origin origin : this.origins.values()) {
            this.grantPowersFromOrigin(origin);
        }
        for (Origin origin : this.origins.values()) {
            this.revokeRemovedPowers(origin, powerComponent);
        }
        if (!compoundTag.method_10545("Powers")) {
            return;
        }
        class_2499 legacyPowersNbt = compoundTag.method_10554("Powers", 10);
        for (i = 0; i < legacyPowersNbt.size(); ++i) {
            class_2487 legacyPowerNbt = legacyPowersNbt.method_10602(i);
            String legacyPowerString = legacyPowerNbt.method_10558("Type");
            try {
                class_2960 legacyPowerId = class_2960.method_60654((String)legacyPowerString);
                Power legacyPower = PowerManager.get((class_2960)legacyPowerId);
                if (!powerComponent.hasPower(legacyPower)) continue;
                try {
                    class_2520 legacyPowerData = legacyPowerNbt.method_10580("Data");
                    powerComponent.getPowerType(legacyPower).fromTag(legacyPowerData);
                }
                catch (ClassCastException e) {
                    Origins.LOGGER.warn("Data type of power \"{}\" changed, skipping data for that power on entity {}", (Object)legacyPowerId, (Object)this.player.method_5477().getString());
                }
                continue;
            }
            catch (IllegalArgumentException e) {
                Origins.LOGGER.warn("Power data of unregistered power \"{}\" found on player {}, skipping...", (Object)legacyPowerString, (Object)this.player.method_5477().getString());
            }
        }
    }

    public void writeToNbt(@NotNull class_2487 compoundTag, class_7225.class_7874 wrapperLookup) {
        class_2499 originLayersNbt = new class_2499();
        this.origins.forEach((layer, origin) -> {
            class_2487 originLayerNbt = new class_2487();
            originLayerNbt.method_10582("Layer", layer.getId().toString());
            originLayerNbt.method_10582("Origin", origin.getId().toString());
            originLayersNbt.add((Object)originLayerNbt);
        });
        compoundTag.method_10566("OriginLayers", (class_2520)originLayersNbt);
        compoundTag.method_10556("SelectingOrigin", this.selectingOrigin);
        compoundTag.method_10556("HadOriginBefore", this.hadOriginBefore);
    }

    @Override
    public void sync() {
        ModComponents.ORIGIN.sync((Object)this.player);
    }
}

