/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.networking;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.OriginsClient;
import io.github.apace100.origins.badge.BadgeManager;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.integration.OriginDataLoadedCallback;
import io.github.apace100.origins.networking.packet.VersionHandshakePacket;
import io.github.apace100.origins.networking.packet.s2c.ConfirmOriginS2CPacket;
import io.github.apace100.origins.networking.packet.s2c.OpenChooseOriginScreenS2CPacket;
import io.github.apace100.origins.networking.packet.s2c.SyncBadgeRegistryS2CPacket;
import io.github.apace100.origins.networking.packet.s2c.SyncOriginLayerRegistryS2CPacket;
import io.github.apace100.origins.networking.packet.s2c.SyncOriginRegistryS2CPacket;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayerManager;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.screen.ChooseOriginScreen;
import io.github.apace100.origins.screen.WaitForNextLayerScreen;
import java.util.ArrayList;
import java.util.Collections;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class ModPacketsS2C {
    @Environment(value=EnvType.CLIENT)
    public static void register() {
        ClientConfigurationNetworking.registerGlobalReceiver(VersionHandshakePacket.PACKET_ID, ModPacketsS2C::handleHandshake);
        ClientPlayConnectionEvents.INIT.register((clientPlayNetworkHandler, minecraftClient) -> {
            ClientPlayNetworking.registerReceiver(ConfirmOriginS2CPacket.PACKET_ID, ModPacketsS2C::receiveOriginConfirmation);
            ClientPlayNetworking.registerReceiver(OpenChooseOriginScreenS2CPacket.PACKET_ID, ModPacketsS2C::openOriginScreen);
            ClientPlayNetworking.registerReceiver(SyncOriginLayerRegistryS2CPacket.PACKET_ID, ModPacketsS2C::receiveLayerList);
            ClientPlayNetworking.registerReceiver(SyncOriginRegistryS2CPacket.PACKET_ID, ModPacketsS2C::receiveOriginList);
            ClientPlayNetworking.registerReceiver(SyncBadgeRegistryS2CPacket.PACKET_ID, ModPacketsS2C::receiveBadgeList);
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static void receiveOriginConfirmation(ConfirmOriginS2CPacket packet, ClientPlayNetworking.Context context) {
        class_746 player = context.player();
        OriginLayer layer = OriginLayerManager.get(packet.layerId());
        Origin origin = OriginRegistry.get(packet.originId());
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
        component.setOrigin(layer, origin);
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof WaitForNextLayerScreen) {
            WaitForNextLayerScreen nextLayerScreen = (WaitForNextLayerScreen)class_4372;
            nextLayerScreen.openSelection();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void handleHandshake(VersionHandshakePacket packet, ClientConfigurationNetworking.Context context) {
        context.responseSender().sendPacket((class_8710)new VersionHandshakePacket(Origins.SEMVER));
    }

    @Environment(value=EnvType.CLIENT)
    private static void openOriginScreen(OpenChooseOriginScreenS2CPacket packet, ClientPlayNetworking.Context context) {
        ArrayList<OriginLayer> layers = new ArrayList<OriginLayer>();
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)context.player());
        OriginLayerManager.getLayers().stream().filter(ol -> ol.isEnabled() && !component.hasOrigin((OriginLayer)ol)).forEach(layers::add);
        Collections.sort(layers);
        class_310.method_1551().method_1507((class_437)new ChooseOriginScreen(layers, 0, packet.showBackground()));
    }

    @Environment(value=EnvType.CLIENT)
    private static void receiveOriginList(SyncOriginRegistryS2CPacket packet, ClientPlayNetworking.Context context) {
        OriginsClient.isServerRunningOrigins = true;
        OriginRegistry.reset();
        for (Origin origin : packet.originsById().values()) {
            if (OriginRegistry.contains(origin)) continue;
            origin.validate();
            OriginRegistry.register(origin);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void receiveLayerList(SyncOriginLayerRegistryS2CPacket packet, ClientPlayNetworking.Context context) {
        OriginLayerManager.clear();
        packet.layersById().forEach(OriginLayerManager::register);
        ((OriginDataLoadedCallback)OriginDataLoadedCallback.EVENT.invoker()).onDataLoaded(true);
    }

    @Environment(value=EnvType.CLIENT)
    private static void receiveBadgeList(SyncBadgeRegistryS2CPacket payload, ClientPlayNetworking.Context context) {
        BadgeManager.clear();
        payload.badgesById().forEach(BadgeManager::putPowerBadges);
    }
}

