/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.apace100.apoli.condition.factory.ConditionTypeFactory;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.calio.Calio;
import io.github.apace100.calio.data.CompoundSerializableDataType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.origins.data.OriginsDataTypes;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayerManager;
import io.github.apace100.origins.origin.OriginRegistry;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class OriginLayer
implements Comparable<OriginLayer> {
    public static final CompoundSerializableDataType<OriginLayer> DATA_TYPE = SerializableDataType.compound((SerializableData)new SerializableData().add("id", (Codec)SerializableDataTypes.IDENTIFIER).addSupplied("order", (Codec)SerializableDataTypes.INT, OriginLayerManager::size).add("origins", OriginsDataTypes.ORIGINS_OR_CONDITIONED_ORIGINS).add("replace", (Codec)SerializableDataTypes.BOOLEAN, (Object)false).add("enabled", (Codec)SerializableDataTypes.BOOLEAN, (Object)true).add("name", (Codec)ApoliDataTypes.DEFAULT_TRANSLATABLE_TEXT, null).add("gui_title", OriginsDataTypes.GUI_TITLE, null).add("missing_name", (Codec)ApoliDataTypes.DEFAULT_TRANSLATABLE_TEXT, null).add("missing_description", (Codec)ApoliDataTypes.DEFAULT_TRANSLATABLE_TEXT, null).add("allow_random", (Codec)SerializableDataTypes.BOOLEAN, (Object)false).add("allow_random_unchoosable", (Codec)SerializableDataTypes.BOOLEAN, (Object)false).add("exclude_random", (Codec)SerializableDataTypes.IDENTIFIERS, new LinkedList()).add("replace_exclude_random", (Codec)SerializableDataTypes.BOOLEAN, (Object)false).add("default_origin", (Codec)SerializableDataTypes.IDENTIFIER, null).add("auto_choose", (Codec)SerializableDataTypes.BOOLEAN, (Object)false).add("hidden", (Codec)SerializableDataTypes.BOOLEAN, (Object)false).postProcessor(data -> {
        class_2960 id = (class_2960)data.get("id");
        String baseKey = class_156.method_646((String)"layer", (class_2960)id);
        if (!data.isPresent("name")) {
            data.set("name", (Object)class_2561.method_43471((String)(baseKey + ".name")));
        }
        if (!data.isPresent("gui_title")) {
            class_2561 name = (class_2561)data.get("name");
            class_5250 viewOriginText = class_2561.method_43469((String)"origins.gui.view_origin.title", (Object[])new Object[]{name});
            class_5250 chooseOriginText = class_2561.method_43469((String)"origins.gui.choose_origin.title", (Object[])new Object[]{name});
            data.set("gui_title", (Object)new GuiTitle((class_2561)viewOriginText, (class_2561)chooseOriginText));
        } else {
            GuiTitle guiTitle = (GuiTitle)data.get("gui_title");
            class_2561 viewOriginText = Optional.ofNullable(guiTitle.viewOrigin()).orElseGet(() -> class_2561.method_43471((String)(baseKey + ".view_origin.name")));
            class_2561 chooseOriginText = Optional.ofNullable(guiTitle.chooseOrigin()).orElseGet(() -> class_2561.method_43471((String)(baseKey + ".choose_origin.name")));
            data.set("gui_title", (Object)new GuiTitle(viewOriginText, chooseOriginText));
        }
    }), data -> new OriginLayer((class_2960)data.get("id"), (Integer)data.get("order"), (List)data.get("origins"), (Boolean)data.get("replace"), (Boolean)data.get("enabled"), (class_2561)data.get("name"), (GuiTitle)data.get("gui_title"), (class_2561)data.get("missing_name"), (class_2561)data.get("missing_description"), (Boolean)data.get("allow_random"), (Boolean)data.get("allow_random_unchoosable"), (List)data.get("exclude_random"), (Boolean)data.get("replace_exclude_random"), (class_2960)data.get("default_origin"), (Boolean)data.get("auto_choose"), (Boolean)data.get("hidden")), (layer, data) -> data.set("id", (Object)layer.getId()).set("order", (Object)layer.getOrder()).set("origins", layer.getConditionedOrigins()).set("replace", (Object)layer.shouldReplace()).set("enabled", (Object)layer.isEnabled()).set("name", (Object)layer.getName()).set("gui_title", (Object)layer.guiTitle).set("missing_name", (Object)layer.getMissingName()).set("missing_description", (Object)layer.getMissingDescription()).set("allow_random", (Object)layer.isRandomAllowed()).set("allow_random_unchoosable", (Object)layer.unchoosableRandomAllowed).set("exclude_random", layer.originsExcludedFromRandom).set("replace_exclude_random", (Object)layer.replaceOriginsExcludedFromRandom).set("default_origin", (Object)layer.getDefaultOrigin()).set("auto_choose", (Object)layer.shouldAutoChoose()).set("hidden", (Object)layer.isHidden()));
    private final class_2960 id;
    private final int order;
    private final List<ConditionedOrigin> origins;
    private final boolean replaceOrigins;
    private final boolean enabled;
    private final class_2561 name;
    private final GuiTitle guiTitle;
    @Nullable
    private final class_2561 missingName;
    @Nullable
    private final class_2561 missingDescription;
    private final boolean randomAllowed;
    private final boolean unchoosableRandomAllowed;
    private final List<class_2960> originsExcludedFromRandom;
    private final boolean replaceOriginsExcludedFromRandom;
    @Nullable
    private final class_2960 defaultOrigin;
    private final boolean autoChoose;
    private final boolean hidden;

    protected OriginLayer(class_2960 id, int order, List<ConditionedOrigin> origins, boolean replaceOrigins, boolean enabled, class_2561 name, GuiTitle guiTitle, @Nullable class_2561 missingName, @Nullable class_2561 missingDescription, boolean randomAllowed, boolean unchoosableRandomAllowed, List<class_2960> originsExcludedFromRandom, boolean replaceOriginsExcludedFromRandom, @Nullable class_2960 defaultOrigin, boolean autoChoose, boolean hidden) {
        this.id = id;
        this.order = order;
        this.origins = origins;
        this.replaceOrigins = replaceOrigins;
        this.enabled = enabled;
        this.name = name;
        this.guiTitle = guiTitle;
        this.missingName = missingName;
        this.missingDescription = missingDescription;
        this.randomAllowed = randomAllowed;
        this.unchoosableRandomAllowed = unchoosableRandomAllowed;
        this.originsExcludedFromRandom = originsExcludedFromRandom;
        this.replaceOriginsExcludedFromRandom = replaceOriginsExcludedFromRandom;
        this.defaultOrigin = defaultOrigin;
        this.autoChoose = autoChoose;
        this.hidden = hidden;
    }

    public int getOrder() {
        return this.order;
    }

    public List<ConditionedOrigin> getConditionedOrigins() {
        return this.origins;
    }

    public class_2561 getName() {
        return this.name;
    }

    @Nullable
    public class_2561 getMissingName() {
        return this.missingName;
    }

    @Nullable
    public class_2561 getMissingDescription() {
        return this.missingDescription;
    }

    public class_2561 getViewOriginTitle() {
        return this.guiTitle.viewOrigin();
    }

    public class_2561 getChooseOriginTitle() {
        return this.guiTitle.chooseOrigin();
    }

    public boolean shouldReplace() {
        return this.replaceOrigins;
    }

    public boolean shouldReplaceExcludedOriginsFromRandom() {
        return this.replaceOriginsExcludedFromRandom;
    }

    public class_2960 getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasDefaultOrigin() {
        return this.getDefaultOrigin() != null;
    }

    @Nullable
    public class_2960 getDefaultOrigin() {
        return this.defaultOrigin;
    }

    public boolean shouldAutoChoose() {
        return this.autoChoose;
    }

    public List<class_2960> getOrigins() {
        return this.getOrigins(null);
    }

    public List<class_2960> getOrigins(@Nullable class_1657 playerEntity) {
        return this.origins.stream().filter(co -> playerEntity == null || co.isConditionFulfilled(playerEntity)).flatMap(co -> co.origins.stream()).filter(OriginRegistry::contains).collect(Collectors.toList());
    }

    public int getOriginOptionCount(class_1657 playerEntity) {
        int choosableOrigins = (int)this.getOrigins(playerEntity).stream().map(OriginRegistry::get).filter(Origin::isChoosable).count();
        if (choosableOrigins > 1 && this.randomAllowed && !this.getRandomOrigins(playerEntity).isEmpty()) {
            ++choosableOrigins;
        }
        return choosableOrigins;
    }

    public boolean contains(class_2960 originId) {
        return this.origins.stream().flatMap(co -> co.origins().stream()).anyMatch(arg_0 -> ((class_2960)originId).equals(arg_0));
    }

    public boolean contains(Origin origin) {
        return this.contains(origin.getId());
    }

    public boolean contains(class_2960 originId, class_1657 playerEntity) {
        return this.origins.stream().filter(co -> co.isConditionFulfilled(playerEntity)).flatMap(co -> co.origins().stream()).anyMatch(arg_0 -> ((class_2960)originId).equals(arg_0));
    }

    public boolean contains(Origin origin, class_1657 playerEntity) {
        return this.contains(origin.getId(), playerEntity);
    }

    public boolean isRandomAllowed() {
        return this.randomAllowed;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<class_2960> getRandomOrigins(class_1657 playerEntity) {
        return this.origins.stream().filter(co -> co.isConditionFulfilled(playerEntity)).flatMap(co -> co.origins.stream()).filter(OriginRegistry::contains).filter(oId -> !this.originsExcludedFromRandom.contains(oId)).filter(oid -> this.unchoosableRandomAllowed || OriginRegistry.get(oid).isChoosable()).collect(Collectors.toList());
    }

    public OriginLayer merge(OriginLayer otherLayer) {
        LinkedHashSet<ConditionedOrigin> origins = new LinkedHashSet<ConditionedOrigin>(this.getConditionedOrigins());
        LinkedHashSet<class_2960> originsExcludedFromRandom = new LinkedHashSet<class_2960>(this.originsExcludedFromRandom);
        if (otherLayer.shouldReplace()) {
            origins.clear();
        }
        if (otherLayer.shouldReplaceExcludedOriginsFromRandom()) {
            originsExcludedFromRandom.clear();
        }
        origins.addAll(otherLayer.getConditionedOrigins());
        originsExcludedFromRandom.addAll(otherLayer.originsExcludedFromRandom);
        return new OriginLayer(this.getId(), otherLayer.getOrder(), new LinkedList<ConditionedOrigin>(origins), otherLayer.shouldReplace(), otherLayer.isEnabled(), otherLayer.getName(), otherLayer.guiTitle, otherLayer.getMissingName(), otherLayer.getMissingDescription(), otherLayer.isRandomAllowed(), otherLayer.unchoosableRandomAllowed, new LinkedList<class_2960>(originsExcludedFromRandom), otherLayer.shouldReplaceExcludedOriginsFromRandom(), otherLayer.getDefaultOrigin(), otherLayer.shouldAutoChoose(), otherLayer.isHidden());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof OriginLayer)) return false;
        OriginLayer that = (OriginLayer)obj;
        if (!Objects.equals(this.getId(), that.getId())) return false;
        return true;
    }

    @Override
    public int compareTo(OriginLayer that) {
        return Integer.compare(this.order, that.order);
    }

    public String toString() {
        return "OriginLayer{id=" + String.valueOf(this.id) + ", order=" + this.order + ", origins=" + String.valueOf(this.getOrigins()) + ", replaceOrigins=" + this.replaceOrigins + ", enabled=" + this.enabled + ", name=" + String.valueOf(this.name) + ", guiTitle=" + String.valueOf(this.guiTitle) + ", missingName=" + String.valueOf(this.missingName) + ", missingDescription=" + String.valueOf(this.missingDescription) + ", randomAllowed=" + this.randomAllowed + ", unchoosableRandomAllowed=" + this.unchoosableRandomAllowed + ", originsExcludedFromRandom=" + String.valueOf(this.originsExcludedFromRandom) + ", replaceOriginsExcludedFromRandom=" + this.replaceOriginsExcludedFromRandom + ", defaultOrigin=" + String.valueOf(this.defaultOrigin) + ", autoChoose=" + this.autoChoose + ", hidden=" + this.hidden + "}";
    }

    public static OriginLayer fromJson(class_2960 id, JsonObject jsonObject) {
        jsonObject.addProperty("id", id.toString());
        return (OriginLayer)DATA_TYPE.strictParse(Calio.wrapRegistryOps((DynamicOps)JsonOps.INSTANCE), (Object)jsonObject);
    }

    public record GuiTitle(@Nullable class_2561 viewOrigin, @Nullable class_2561 chooseOrigin) {
        public static final CompoundSerializableDataType<GuiTitle> DATA_TYPE = SerializableDataType.compound((SerializableData)new SerializableData().add("view_origin", (Codec)SerializableDataTypes.TEXT, null).add("choose_origin", (Codec)SerializableDataTypes.TEXT, null), data -> new GuiTitle((class_2561)data.get("view_origin"), (class_2561)data.get("choose_origin")), (guiTitle, data) -> data.set("view_origin", (Object)guiTitle.viewOrigin()).set("choose_origin", (Object)guiTitle.viewOrigin));
    }

    public record ConditionedOrigin(@Nullable ConditionTypeFactory.Instance condition, List<class_2960> origins) {
        public static final CompoundSerializableDataType<ConditionedOrigin> DATA_TYPE = SerializableDataType.compound((SerializableData)new SerializableData().add("condition", (Codec)ApoliDataTypes.ENTITY_CONDITION, null).add("origins", (Codec)SerializableDataTypes.IDENTIFIERS), data -> new ConditionedOrigin((ConditionTypeFactory.Instance)data.get("condition"), (List)data.get("origins")), (conditionedOrigin, data) -> data.set("condition", (Object)conditionedOrigin.condition()).set("origins", conditionedOrigin.origins()));

        public boolean isConditionFulfilled(class_1657 playerEntity) {
            return this.condition == null || this.condition.test((Object)playerEntity);
        }
    }
}

