/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.apace100.apoli.util.PrioritizedEntry;
import io.github.apace100.calio.data.IdentifiableMultiJsonDataLoader;
import io.github.apace100.calio.data.MultiJsonDataContainer;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.integration.OriginDataLoadedCallback;
import io.github.apace100.origins.networking.packet.s2c.OpenChooseOriginScreenS2CPacket;
import io.github.apace100.origins.networking.packet.s2c.SyncOriginLayerRegistryS2CPacket;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginManager;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModComponents;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.ComponentProvider;

public class OriginLayerManager
extends IdentifiableMultiJsonDataLoader
implements IdentifiableResourceReloadListener {
    public static final class_2960 PHASE = Origins.identifier("phase/origin_layers");
    public static final Codec<class_2960> VALIDATING_CODEC = class_2960.field_25139.comapFlatMap(id -> OriginLayerManager.contains(id) ? DataResult.success((Object)id) : DataResult.error(() -> "Could not get layer from id '" + String.valueOf(id) + "', as it doesn't exist!"), id -> id);
    public static final class_9139<ByteBuf, OriginLayer> DISPATCH_PACKET_CODEC = class_2960.field_48267.method_56432(OriginLayerManager::get, OriginLayer::getId);
    public static final Codec<OriginLayer> DISPATCH_CODEC = class_2960.field_25139.comapFlatMap(OriginLayerManager::getResult, OriginLayer::getId);
    private static final Map<class_2960, Integer> LOADING_PRIORITIES = new HashMap<class_2960, Integer>();
    private static final Map<class_2960, OriginLayer> LAYERS = new HashMap<class_2960, OriginLayer>();
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    public OriginLayerManager() {
        super(GSON, "origin_layers", class_3264.field_14190);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.addPhaseOrdering(OriginManager.PHASE, PHASE);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(PHASE, (player, joined) -> {
            OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
            HashMap<class_2960, OriginLayer> layers = new HashMap<class_2960, OriginLayer>();
            for (OriginLayer layer : OriginLayerManager.getLayers()) {
                layers.put(layer.getId(), layer);
                if (!layer.isEnabled() || component.hasOrigin(layer)) continue;
                component.setOrigin(layer, Origin.EMPTY);
            }
            ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncOriginLayerRegistryS2CPacket(layers));
            if (joined) {
                List otherPlayers = player.method_51469().method_8503().method_3760().method_14571();
                otherPlayers.remove(player);
                otherPlayers.forEach(otherPlayer -> ModComponents.ORIGIN.syncWith(otherPlayer, (ComponentProvider)player));
            }
            this.postLoading(player, joined);
        });
    }

    private void postLoading(class_3222 player, boolean init) {
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
        boolean mismatch = false;
        for (Map.Entry<OriginLayer, Origin> entry : component.getOrigins().entrySet()) {
            boolean originUnregistered;
            OriginLayer oldLayer = entry.getKey();
            Origin oldOrigin = entry.getValue();
            boolean originOrLayerNotAvailable = !OriginLayerManager.contains(oldLayer) || !OriginRegistry.contains(oldOrigin);
            boolean bl = originUnregistered = OriginLayerManager.contains(oldLayer) && !OriginLayerManager.get(oldLayer.getId()).contains(oldOrigin);
            if (originOrLayerNotAvailable || originUnregistered) {
                if (oldOrigin == Origin.EMPTY) continue;
                if (originUnregistered) {
                    Origins.LOGGER.error("Removed unregistered origin \"{}\" from origin layer \"{}\" from player {}!", (Object)oldOrigin.getId(), (Object)oldLayer.getId(), (Object)player.method_5477().getString());
                    component.setOrigin(oldLayer, Origin.EMPTY);
                    continue;
                }
                Origins.LOGGER.error("Removed unregistered origin layer \"{}\" from player {}!", (Object)oldLayer.getId(), (Object)player.method_5477().getString());
                component.removeLayer(oldLayer);
                continue;
            }
            Origin newOrigin = OriginRegistry.get(oldOrigin.getId());
            if (oldOrigin.toJson().equals((Object)newOrigin.toJson())) continue;
            Origins.LOGGER.warn("Mismatched data fields of origin \"{}\" from player {}! Updating...", (Object)oldOrigin.getId(), (Object)player.method_5477().getString());
            mismatch = true;
            component.setOrigin(oldLayer, newOrigin);
        }
        if (mismatch) {
            Origins.LOGGER.info("Finished updating origin data of player {}!", (Object)player.method_5477().getString());
        }
        OriginComponent.sync((class_1657)player);
        if (component.hasAllOrigins()) {
            return;
        }
        if (component.checkAutoChoosingLayers((class_1657)player, true)) {
            component.sync();
        }
        if (!init) {
            return;
        }
        if (component.hasAllOrigins()) {
            OriginComponent.onChosen((class_1657)player, false);
        } else if (!OriginLayerManager.isFakePlayer(player)) {
            component.selectingOrigin(true);
            component.sync();
            ServerPlayNetworking.send((class_3222)player, (class_8710)new OpenChooseOriginScreenS2CPacket(true));
        } else {
            component.sync();
        }
    }

    private static boolean isFakePlayer(class_3222 player) {
        return FabricLoader.getInstance().isModLoaded("carpet") && player instanceof EntityPlayerMPFake;
    }

    protected void apply(MultiJsonDataContainer prepared, class_3300 manager, class_3695 profiler) {
        LOADING_PRIORITIES.clear();
        OriginLayerManager.clear();
        HashMap<class_2960, List> loadedLayers = new HashMap<class_2960, List>();
        Origins.LOGGER.info("Loading origin layers from data packs...");
        prepared.forEach((packName, id, jsonElement) -> {
            try {
                SerializableData.CURRENT_NAMESPACE = id.method_12836();
                SerializableData.CURRENT_PATH = id.method_12832();
                Origins.LOGGER.info("Trying to add origin layer \"{}\" from data pack [{}]", (Object)id, (Object)packName);
                if (!(jsonElement instanceof JsonObject)) {
                    throw new JsonSyntaxException("Expected a JSON object");
                }
                JsonObject jsonObject = (JsonObject)jsonElement;
                OriginLayer layer = OriginLayer.fromJson(id, jsonObject);
                int currLoadingPriority = class_3518.method_15282((JsonObject)jsonObject, (String)"loading_priority", (int)0);
                PrioritizedEntry entry = new PrioritizedEntry((Object)layer, currLoadingPriority);
                int prevLoadingPriority = LOADING_PRIORITIES.getOrDefault(id, Integer.MIN_VALUE);
                if (layer.shouldReplace() && currLoadingPriority <= prevLoadingPriority) {
                    Origins.LOGGER.warn("Ignoring origin layer \"{}\" with 'replace' set to true from data pack [{}]. Its loading priority ({}) must be higher than {} to replace the origin layer!", (Object)id, (Object)packName, (Object)currLoadingPriority, (Object)prevLoadingPriority);
                } else {
                    List<String> invalidOrigins;
                    if (layer.shouldReplace()) {
                        Origins.LOGGER.info("Origin layer \"{}\" has been replaced by data pack [{}]!", (Object)id, (Object)packName);
                    }
                    if (!(invalidOrigins = layer.getConditionedOrigins().stream().map(OriginLayer.ConditionedOrigin::origins).flatMap(Collection::stream).filter(Predicate.not(OriginRegistry::contains)).map(class_2960::toString).toList()).isEmpty()) {
                        Origins.LOGGER.error("Origin layer \"{}\" contained {} invalid origin(s): {}", (Object)id, (Object)invalidOrigins.size(), (Object)String.join((CharSequence)", ", invalidOrigins));
                    }
                    loadedLayers.computeIfAbsent(id, k -> new LinkedList()).add(entry);
                    LOADING_PRIORITIES.put(id, currLoadingPriority);
                }
            }
            catch (Exception e) {
                Origins.LOGGER.error("There was a problem reading origin layer \"{}\": {}", (Object)id, (Object)e.getMessage());
            }
        });
        Origins.LOGGER.info("Finished loading {} origin layer(s). Merging similar origin layers...", (Object)loadedLayers.size());
        loadedLayers.forEach((id, entries) -> {
            AtomicReference<OriginLayer> currentLayer = new AtomicReference<OriginLayer>();
            entries.sort(Comparator.comparing(PrioritizedEntry::priority));
            for (PrioritizedEntry entry : entries) {
                if (currentLayer.get() == null) {
                    currentLayer.set((OriginLayer)entry.value());
                    continue;
                }
                currentLayer.accumulateAndGet((OriginLayer)entry.value(), OriginLayer::merge);
            }
            OriginLayerManager.register(id, (OriginLayer)currentLayer.get());
        });
        Origins.LOGGER.info("Finished merging similar origin layers. Registry contains {} origin layer(s).", (Object)OriginLayerManager.size());
        ((OriginDataLoadedCallback)OriginDataLoadedCallback.EVENT.invoker()).onDataLoaded(false);
        SerializableData.CURRENT_NAMESPACE = null;
        SerializableData.CURRENT_PATH = null;
        LOADING_PRIORITIES.clear();
    }

    public static DataResult<OriginLayer> getResult(class_2960 id) {
        return LAYERS.containsKey(id) ? DataResult.success((Object)LAYERS.get(id)) : DataResult.error(() -> "Could not get layer from id '" + id.toString() + "', as it doesn't exist!");
    }

    public static OriginLayer get(class_2960 id) {
        if (!LAYERS.containsKey(id)) {
            throw new IllegalArgumentException("Could not get layer from id '" + id.toString() + "', as it doesn't exist!");
        }
        return LAYERS.get(id);
    }

    @Nullable
    public static OriginLayer getNullable(class_2960 id) {
        return LAYERS.get(id);
    }

    public static void register(class_2960 id, OriginLayer layer) {
        if (LAYERS.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate origin layer id tried to register: '" + String.valueOf(id) + "'");
        }
        LAYERS.put(id, layer);
    }

    public static Collection<OriginLayer> getLayers() {
        return LAYERS.values();
    }

    public static int getOriginOptionCount(class_1657 playerEntity) {
        return OriginLayerManager.getOriginOptionCount(playerEntity, (layer, component) -> !component.hasOrigin((OriginLayer)layer));
    }

    public static int getOriginOptionCount(class_1657 playerEntity, BiPredicate<OriginLayer, OriginComponent> condition) {
        return LAYERS.values().stream().filter(ol -> ol.isEnabled() && ModComponents.ORIGIN.maybeGet((Object)playerEntity).map(oc -> condition.test((OriginLayer)ol, (OriginComponent)oc)).orElse(false) != false).flatMapToInt(ol -> IntStream.of(ol.getOriginOptionCount(playerEntity))).sum();
    }

    public static boolean contains(OriginLayer layer) {
        return OriginLayerManager.contains(layer.getId());
    }

    public static boolean contains(class_2960 id) {
        return LAYERS.containsKey(id);
    }

    public static int size() {
        return LAYERS.size();
    }

    public static void clear() {
        LAYERS.clear();
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"origins", (String)"origin_layers");
    }

    public Collection<class_2960> getFabricDependencies() {
        return Set.of(Origins.identifier("origins"));
    }
}

