/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.apace100.apoli.power.PowerManager;
import io.github.apace100.calio.data.IdentifiableMultiJsonDataLoader;
import io.github.apace100.calio.data.MultiJsonDataContainer;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;

public class OriginManager
extends IdentifiableMultiJsonDataLoader
implements IdentifiableResourceReloadListener {
    public static final class_2960 PHASE = Origins.identifier("phase/origins");
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private static final Map<class_2960, Integer> LOADING_PRIORITIES = new HashMap<class_2960, Integer>();

    public OriginManager() {
        super(GSON, "origins", class_3264.field_14190);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.addPhaseOrdering(PowerManager.PHASE, PHASE);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(PHASE, (player, joined) -> OriginRegistry.send(player));
    }

    protected void apply(MultiJsonDataContainer prepared, class_3300 manager, class_3695 profiler) {
        LOADING_PRIORITIES.clear();
        OriginRegistry.reset();
        AtomicBoolean hasConfigChanged = new AtomicBoolean(false);
        prepared.forEach((packName, id, jsonElement) -> {
            try {
                SerializableData.CURRENT_NAMESPACE = id.method_12836();
                SerializableData.CURRENT_PATH = id.method_12832();
                if (!(jsonElement instanceof JsonObject)) {
                    throw new JsonSyntaxException("Expected a JSON object");
                }
                JsonObject jsonObject = (JsonObject)jsonElement;
                Origin origin = Origin.fromJson(id, jsonObject);
                int prevLoadingPriority = LOADING_PRIORITIES.computeIfAbsent(id, k -> 0);
                int currLoadingPriority = class_3518.method_15282((JsonObject)jsonObject, (String)"loading_priority", (int)0);
                if (!OriginRegistry.contains(id)) {
                    origin.validate();
                    OriginRegistry.register(id, origin);
                    LOADING_PRIORITIES.put(id, currLoadingPriority);
                } else if (prevLoadingPriority < currLoadingPriority) {
                    Origins.LOGGER.warn("Overriding origin \"{}\" (with prev. loading priority of {}) with a higher loading priority of {} from data pack [{}]!", (Object)id, (Object)prevLoadingPriority, (Object)currLoadingPriority, (Object)packName);
                    origin.validate();
                    OriginRegistry.update(id, origin);
                    LOADING_PRIORITIES.put(id, currLoadingPriority);
                } else {
                    origin = OriginRegistry.get(id);
                    hasConfigChanged.set(hasConfigChanged.get() | Origins.config.addToConfig(origin));
                    if (Origins.config.isOriginDisabled(id)) {
                        OriginRegistry.remove(id);
                    }
                }
            }
            catch (Exception e) {
                Origins.LOGGER.error("There was a problem reading origin file \"{}\" (skipping): {}", (Object)id, (Object)e.getMessage());
            }
        });
        Origins.LOGGER.info("Finished loading origins from data files. Registry contains {} origins.", (Object)OriginRegistry.size());
        if (hasConfigChanged.get()) {
            Origins.serializeConfig();
        }
        LOADING_PRIORITIES.clear();
        SerializableData.CURRENT_NAMESPACE = null;
        SerializableData.CURRENT_PATH = null;
    }

    public class_2960 getFabricId() {
        return Origins.identifier("origins");
    }

    public Collection<class_2960> getFabricDependencies() {
        return Set.of(PowerManager.ID);
    }
}

