/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.apace100.origins.networking.packet.s2c.SyncOriginRegistryS2CPacket;
import io.github.apace100.origins.origin.Origin;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class OriginRegistry {
    public static final Codec<class_2960> VALIDATING_CODEC = class_2960.field_25139.comapFlatMap(id -> OriginRegistry.contains(id) ? DataResult.success((Object)id) : DataResult.error(() -> "Could not get origin from id '" + String.valueOf(id) + "', as it was not registered!"), id -> id);
    public static final class_9139<ByteBuf, Origin> DISPATCH_PACKET_CODEC = class_2960.field_48267.method_56432(OriginRegistry::get, Origin::getId);
    public static final Codec<Origin> DISPATCH_CODEC = class_2960.field_25139.comapFlatMap(OriginRegistry::getResult, Origin::getId);
    private static final Map<class_2960, Origin> idToOrigin = new HashMap<class_2960, Origin>();

    public static Origin register(Origin origin) {
        return OriginRegistry.register(origin.getId(), origin);
    }

    public static Origin register(class_2960 id, Origin origin) {
        if (idToOrigin.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate origin id tried to register: '" + id.toString() + "'");
        }
        idToOrigin.put(id, origin);
        return origin;
    }

    protected static Origin update(class_2960 id, Origin origin) {
        idToOrigin.remove(id);
        return OriginRegistry.register(id, origin);
    }

    public static int size() {
        return idToOrigin.size();
    }

    public static Set<class_2960> keys() {
        return idToOrigin.keySet();
    }

    public static Set<Map.Entry<class_2960, Origin>> entries() {
        return idToOrigin.entrySet();
    }

    public static Collection<Origin> values() {
        return idToOrigin.values();
    }

    public static DataResult<Origin> getResult(class_2960 id) {
        return idToOrigin.containsKey(id) ? DataResult.success((Object)idToOrigin.get(id)) : DataResult.error(() -> "Could not get origin from id '" + id.toString() + "', as it was not registered!");
    }

    public static Origin get(class_2960 id) {
        if (!idToOrigin.containsKey(id)) {
            throw new IllegalArgumentException("Could not get origin from id '" + id.toString() + "', as it was not registered!");
        }
        return idToOrigin.get(id);
    }

    @Nullable
    public static Origin getNullable(class_2960 originId) {
        return idToOrigin.get(originId);
    }

    public static boolean contains(class_2960 id) {
        return idToOrigin.containsKey(id);
    }

    public static boolean contains(Origin origin) {
        return OriginRegistry.contains(origin.getId());
    }

    public static void clear() {
        idToOrigin.clear();
    }

    public static void reset() {
        OriginRegistry.clear();
        OriginRegistry.register(Origin.EMPTY);
    }

    public static void remove(class_2960 id) {
        idToOrigin.remove(id);
    }

    public static void send(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncOriginRegistryS2CPacket(idToOrigin));
    }
}

