/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.networking.packet.c2s.ChooseOriginC2SPacket;
import io.github.apace100.origins.networking.packet.c2s.ChooseRandomOriginC2SPacket;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModItems;
import io.github.apace100.origins.screen.OriginDisplayScreen;
import io.github.apace100.origins.screen.WaitForNextLayerScreen;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class ChooseOriginScreen
extends OriginDisplayScreen {
    private final List<OriginLayer> layerList;
    private final List<Origin> originSelection;
    private final int currentLayerIndex;
    private Origin randomOrigin;
    private int currentOriginIndex = 0;
    private int maxSelection = 0;

    public ChooseOriginScreen(List<OriginLayer> layerList, int currentLayerIndex, boolean showDirtBackground) {
        super((class_2561)class_2561.method_43471((String)"origins.screen.choose_origin"), showDirtBackground);
        this.layerList = layerList;
        this.currentLayerIndex = currentLayerIndex;
        this.originSelection = new ArrayList<Origin>(layerList.size());
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        OriginLayer currentLayer = this.getCurrentLayer();
        currentLayer.getOrigins((class_1657)player).forEach(arg_0 -> this.lambda$new$0((class_1657)player, arg_0));
        this.originSelection.sort(Comparator.comparingInt(o -> o.getImpact().getImpactValue()).thenComparingInt(Origin::getOrder));
        this.maxSelection = currentLayer.getOriginOptionCount((class_1657)player);
        if (this.maxSelection == 0) {
            this.openNextLayerScreen();
        }
        Origin newOrigin = this.getCurrentOrigin();
        this.showOrigin(newOrigin, this.getCurrentLayer(), newOrigin == this.randomOrigin);
    }

    private void openNextLayerScreen() {
        class_310.method_1551().method_1507((class_437)new WaitForNextLayerScreen(this.layerList, this.currentLayerIndex, this.showDirtBackground));
    }

    public boolean method_25422() {
        return false;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.maxSelection <= 0) {
            return;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"origins.gui.select"), button -> {
            class_2960 originId = super.getCurrentOrigin().getId();
            class_2960 layerId = this.getCurrentLayer().getId();
            if (this.currentOriginIndex == this.originSelection.size()) {
                ClientPlayNetworking.send((class_8710)new ChooseRandomOriginC2SPacket(layerId));
            } else {
                ClientPlayNetworking.send((class_8710)new ChooseOriginC2SPacket(layerId, originId));
            }
            this.openNextLayerScreen();
        }).method_46434(this.guiLeft + 88 - 50, this.guiTop + 182 + 5, 100, 20).method_46431());
        if (this.maxSelection <= 1) {
            return;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"<"), button -> {
            this.currentOriginIndex = (this.currentOriginIndex - 1 + this.maxSelection) % this.maxSelection;
            Origin newOrigin = this.getCurrentOrigin();
            this.showOrigin(newOrigin, this.getCurrentLayer(), newOrigin == this.randomOrigin);
        }).method_46434(this.guiLeft - 40, this.field_22790 / 2 - 10, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)">"), button -> {
            this.currentOriginIndex = (this.currentOriginIndex + 1) % this.maxSelection;
            Origin newOrigin = this.getCurrentOrigin();
            this.showOrigin(newOrigin, this.getCurrentLayer(), newOrigin == this.randomOrigin);
        }).method_46434(this.guiLeft + 176 + 20, this.field_22790 / 2 - 10, 20, 20).method_46431());
    }

    @Override
    public OriginLayer getCurrentLayer() {
        return this.layerList.get(this.currentLayerIndex);
    }

    @Override
    public Origin getCurrentOrigin() {
        if (this.currentOriginIndex == this.originSelection.size()) {
            if (this.randomOrigin == null) {
                this.initRandomOrigin();
            }
            return this.randomOrigin;
        }
        return this.originSelection.get(this.currentOriginIndex);
    }

    @Override
    protected class_2561 getTitleText() {
        return super.getCurrentLayer().getChooseOriginTitle();
    }

    private void initRandomOrigin() {
        this.randomOrigin = Origin.special(Origins.identifier("random"), ModItems.ORB_OF_ORIGIN.method_7854(), Impact.NONE, -1);
        class_5250 randomOriginText = class_2561.method_30163((String)"").method_27661();
        List<class_2960> randoms = this.layerList.get(this.currentLayerIndex).getRandomOrigins((class_1657)class_310.method_1551().field_1724);
        randoms.sort((ia, ib) -> {
            Origin a = OriginRegistry.get(ia);
            Origin b = OriginRegistry.get(ib);
            int impactDelta = Integer.compare(a.getImpact().getImpactValue(), b.getImpact().getImpactValue());
            return impactDelta != 0 ? impactDelta : Integer.compare(a.getOrder(), b.getOrder());
        });
        for (class_2960 id : randoms) {
            randomOriginText.method_10852((class_2561)OriginRegistry.get(id).getName());
            randomOriginText.method_10852(class_2561.method_30163((String)"\n"));
        }
        this.setRandomOriginText((class_2561)randomOriginText);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.maxSelection == 0) {
            this.openNextLayerScreen();
        } else {
            super.method_25394(context, mouseX, mouseY, delta);
        }
    }

    private /* synthetic */ void lambda$new$0(class_1657 player, class_2960 originId) {
        Origin origin = OriginRegistry.get(originId);
        if (!origin.isChoosable()) {
            return;
        }
        class_1799 iconStack = origin.getDisplayItem();
        if (iconStack.method_31574(class_1802.field_8575) && !iconStack.method_57826(class_9334.field_49617)) {
            iconStack.method_57379(class_9334.field_49617, (Object)new class_9296(player.method_7334()));
        }
        this.originSelection.add(origin);
    }
}

