/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import io.github.apace100.apoli.power.MultiplePower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.screen.widget.ScrollingTextWidget;
import io.github.apace100.apoli.util.TextAlignment;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeManager;
import io.github.apace100.origins.mixin.DrawContextAccessor;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8001;

public class OriginDisplayScreen
extends class_437 {
    private static final class_2960 WINDOW_BACKGROUND = Origins.identifier("choose_origin/background");
    private static final class_2960 WINDOW_BORDER = Origins.identifier("choose_origin/border");
    private static final class_2960 WINDOW_NAME_PLATE = Origins.identifier("choose_origin/name_plate");
    private static final class_2960 WINDOW_SCROLL_BAR = Origins.identifier("choose_origin/scroll_bar");
    private static final class_2960 WINDOW_SCROLL_BAR_PRESSED = Origins.identifier("choose_origin/scroll_bar/pressed");
    private static final class_2960 WINDOW_SCROLL_BAR_SLOT = Origins.identifier("choose_origin/scroll_bar/slot");
    protected static final int WINDOW_WIDTH = 176;
    protected static final int WINDOW_HEIGHT = 182;
    private final LinkedList<RenderedBadge> renderedBadges = new LinkedList();
    protected final boolean showDirtBackground;
    private Origin origin;
    private Origin prevOrigin;
    private OriginLayer layer;
    private OriginLayer prevLayer;
    private class_2561 randomOriginText;
    private ScrollingTextWidget originNameWidget;
    private boolean refreshOriginNameWidget = false;
    private boolean isOriginRandom;
    private boolean dragScrolling = false;
    private double mouseDragStart = 0.0;
    private float time = 0.0f;
    private int currentMaxScroll = 0;
    private int scrollDragStart = 0;
    protected int guiTop;
    protected int guiLeft;
    protected int scrollPos = 0;

    public OriginDisplayScreen(class_2561 title, boolean showDirtBackground) {
        super(title);
        this.showDirtBackground = showDirtBackground;
    }

    public void showOrigin(Origin origin, OriginLayer layer, boolean isRandom) {
        this.origin = origin;
        this.layer = layer;
        this.isOriginRandom = isRandom;
        this.scrollPos = 0;
        this.time = 0.0f;
    }

    public void setRandomOriginText(class_2561 text) {
        this.randomOriginText = text;
    }

    protected void method_25426() {
        super.method_25426();
        this.guiLeft = (this.field_22789 - 176) / 2;
        this.guiTop = (this.field_22790 - 182) / 2;
        this.originNameWidget = new ScrollingTextWidget(this.guiLeft + 38, this.guiTop + 18, 90, 9, (class_2561)class_2561.method_43473(), true, this.field_22793);
        this.refreshOriginNameWidget = true;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.showDirtBackground) {
            super.method_25420(context, mouseX, mouseY, delta);
        } else {
            this.method_52752(context);
        }
    }

    public void method_52752(class_332 context) {
        context.method_33284(0, 0, this.field_22789, this.field_22790, -5, 1678774288, -2112876528);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.renderedBadges.clear();
        this.time += delta;
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderOriginWindow(context, mouseX, mouseY, delta);
        if (this.origin != null) {
            this.renderScrollbar(context, mouseX, mouseY);
            this.renderBadgeTooltip(context, mouseX, mouseY);
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.dragScrolling = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean mouseClicked = super.method_25402(mouseX, mouseY, button);
        if (this.cannotScroll()) {
            return mouseClicked;
        }
        this.dragScrolling = false;
        int scrollBarY = 36;
        int maxScrollBarOffset = 141;
        if (!this.canDragScroll(mouseX, mouseY, scrollBarY += (int)((float)(maxScrollBarOffset - scrollBarY) * ((float)this.scrollPos / (float)this.currentMaxScroll)))) {
            return mouseClicked;
        }
        this.dragScrolling = true;
        this.scrollDragStart = scrollBarY;
        this.mouseDragStart = mouseY;
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        boolean mouseDragged = super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        if (!this.dragScrolling) {
            return mouseDragged;
        }
        int delta = (int)(mouseY - this.mouseDragStart);
        int newScrollPos = Math.max(36, Math.min(141, this.scrollDragStart + delta));
        float part = (float)(newScrollPos - 36) / 105.0f;
        this.scrollPos = (int)(part * (float)this.currentMaxScroll);
        return mouseDragged;
    }

    public boolean method_25401(double x, double y, double horizontal, double vertical) {
        int newScrollPos = this.scrollPos - (int)vertical * 4;
        this.scrollPos = class_3532.method_15340((int)newScrollPos, (int)0, (int)this.currentMaxScroll);
        return super.method_25401(x, y, horizontal, vertical);
    }

    public Origin getCurrentOrigin() {
        return this.origin;
    }

    public OriginLayer getCurrentLayer() {
        return this.layer;
    }

    protected void renderScrollbar(class_332 context, int mouseX, int mouseY) {
        if (this.cannotScroll()) {
            return;
        }
        context.method_52706(WINDOW_SCROLL_BAR_SLOT, this.guiLeft + 155, this.guiTop + 35, 8, 134);
        int scrollbarY = 36;
        int maxScrollbarOffset = 141;
        scrollbarY += (int)((float)(maxScrollbarOffset - scrollbarY) * ((float)this.scrollPos / (float)this.currentMaxScroll));
        class_2960 scrollBarTexture = this.dragScrolling || this.canDragScroll(mouseX, mouseY, scrollbarY) ? WINDOW_SCROLL_BAR_PRESSED : WINDOW_SCROLL_BAR;
        context.method_52706(scrollBarTexture, this.guiLeft + 156, this.guiTop + scrollbarY, 6, 27);
    }

    protected boolean cannotScroll() {
        return this.origin == null || this.currentMaxScroll <= 0;
    }

    protected boolean canDragScroll(double mouseX, double mouseY, int scrollBarY) {
        return mouseX >= (double)(this.guiLeft + 156) && mouseX < (double)(this.guiLeft + 156 + 6) && mouseY >= (double)(this.guiTop + scrollBarY) && mouseY < (double)(this.guiTop + scrollBarY + 27);
    }

    protected void renderBadgeTooltip(class_332 context, int mouseX, int mouseY) {
        for (RenderedBadge renderedBadge : this.renderedBadges) {
            if (!this.canRenderBadgeTooltip(renderedBadge, mouseX, mouseY)) continue;
            int widthLimit = this.field_22789 - mouseX - 24;
            ((DrawContextAccessor)context).invokeDrawTooltip(this.field_22793, renderedBadge.getTooltipComponents(this.field_22793, widthLimit), mouseX, mouseY, class_8001.field_41687);
        }
    }

    protected boolean canRenderBadgeTooltip(RenderedBadge renderedBadge, int mouseX, int mouseY) {
        return renderedBadge.hasTooltip() && mouseX >= renderedBadge.x && mouseX < renderedBadge.x + 9 && mouseY >= renderedBadge.y && mouseY < renderedBadge.y + 9;
    }

    protected class_2561 getTitleText() {
        return class_2561.method_30163((String)"Origins");
    }

    protected void renderOriginWindow(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_52707(WINDOW_BACKGROUND, this.guiLeft, this.guiTop, -4, 176, 182);
        if (this.origin != null) {
            this.renderOriginContent(context);
        }
        context.method_52707(WINDOW_BORDER, this.guiLeft, this.guiTop, 2, 176, 182);
        context.method_52707(WINDOW_NAME_PLATE, this.guiLeft + 10, this.guiTop + 10, 2, 150, 26);
        if (this.origin != null) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 5.0f);
            this.renderOriginName(context, mouseX, mouseY, delta);
            this.renderOriginImpact(context, mouseX, mouseY);
            context.method_51448().method_22909();
            context.method_27534(this.field_22793, this.getTitleText(), this.field_22789 / 2, this.guiTop - 15, 0xFFFFFF);
        }
    }

    protected void renderOriginImpact(class_332 context, int mouseX, int mouseY) {
        Impact impact = this.origin.getImpact();
        context.method_52707(impact.getSpriteId(), this.guiLeft + 128, this.guiTop + 19, 2, 28, 8);
        if (this.isHoveringOverImpact(mouseX, mouseY)) {
            class_5250 impactHoverTooltip = class_2561.method_43471((String)"origins.gui.impact.impact").method_27693(": ").method_10852((class_2561)impact.getTextComponent());
            context.method_51438(this.field_22793, (class_2561)impactHoverTooltip, mouseX, mouseY);
        }
    }

    protected boolean isHoveringOverImpact(int mouseX, int mouseY) {
        return mouseX >= this.guiLeft + 128 && mouseX <= this.guiLeft + 158 && mouseY >= this.guiTop + 19 && mouseY <= this.guiTop + 27;
    }

    protected void renderOriginName(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.refreshOriginNameWidget || this.origin != this.prevOrigin || this.layer != this.prevLayer) {
            class_5250 name = this.origin == Origin.EMPTY && this.layer != null && this.layer.getMissingName() != null ? this.layer.getMissingName() : this.origin.getName();
            this.originNameWidget = new ScrollingTextWidget(this.guiLeft + 38, this.guiTop + 18, 90, 9, (class_2561)name, true, this.field_22793);
            this.originNameWidget.setAlignment(TextAlignment.LEFT);
            this.refreshOriginNameWidget = false;
            this.prevOrigin = this.origin;
            this.prevLayer = this.layer;
        }
        this.originNameWidget.method_25394(context, mouseX, mouseY, delta);
        class_1799 iconStack = this.getCurrentOrigin().getDisplayItem();
        context.method_51427(iconStack, this.guiLeft + 15, this.guiTop + 15);
    }

    protected void renderOriginContent(class_332 context) {
        int y;
        int textWidthLimit = 128;
        int x = this.guiLeft + 18;
        int startY = y = this.guiTop + 50;
        int endY = y - 72 + 182;
        y -= this.scrollPos;
        class_5250 description = this.origin == Origin.EMPTY && this.layer != null && this.layer.getMissingDescription() != null ? this.layer.getMissingDescription() : this.origin.getDescription();
        for (class_5481 descriptionLine : this.field_22793.method_1728((class_5348)description, textWidthLimit)) {
            if (y >= startY - 24 && y <= endY + 12) {
                context.method_35720(this.field_22793, descriptionLine, x + 2, y, 0xCCCCCC);
            }
            y += 12;
        }
        y += 12;
        if (this.isOriginRandom) {
            for (class_5481 randomOriginLine : this.field_22793.method_1728((class_5348)this.randomOriginText, textWidthLimit)) {
                if ((y += 12) < startY - 24 || y > endY + 12) continue;
                context.method_35720(this.field_22793, randomOriginLine, x + 2, y, 0xCCCCCC);
            }
            y += 14;
        } else {
            for (Power power : this.origin.getPowers()) {
                if (power.isHidden()) continue;
                LinkedList powerName = new LinkedList(this.field_22793.method_1728((class_5348)power.getName().method_27692(class_124.field_1073), textWidthLimit));
                int powerNameWidth = this.field_22793.method_30880((class_5481)powerName.getLast());
                for (class_5481 powerNameLine : powerName) {
                    if (y >= startY - 24 && y <= endY + 12) {
                        context.method_35720(this.field_22793, powerNameLine, x, y, 0xFFFFFF);
                    }
                    y += 12;
                }
                y -= 12;
                int badgeStartX = x + powerNameWidth + 4;
                int badgeEndX = x + 135;
                int badgeOffsetX = 0;
                int badgeOffsetY = 0;
                for (Power selfOrSubPower : this.getSelfOrSubPowers(power, BadgeManager::hasPowerBadges)) {
                    for (Badge badge : BadgeManager.getPowerBadges(selfOrSubPower.getId())) {
                        int badgeX = badgeStartX + 10 * badgeOffsetX;
                        int badgeY = y - 1 + 10 * badgeOffsetY;
                        if (badgeX >= badgeEndX) {
                            badgeOffsetX = 0;
                            badgeX = badgeStartX = x;
                            badgeY = y - 1 + 10 * ++badgeOffsetY;
                        }
                        if (badgeY >= startY - 34 && badgeY <= endY + 12) {
                            RenderedBadge renderedBadge = new RenderedBadge(selfOrSubPower, badge, badgeX, badgeY);
                            this.renderedBadges.add(renderedBadge);
                            context.method_25291(badge.spriteId(), renderedBadge.x, renderedBadge.y, -2, 0.0f, 0.0f, 9, 9, 9, 9);
                        }
                        ++badgeOffsetX;
                    }
                }
                y += badgeOffsetY * 10;
                for (class_5481 powerDescriptionLine : this.field_22793.method_1728((class_5348)power.getDescription(), textWidthLimit)) {
                    if ((y += 12) < startY - 24 || y > endY + 12) continue;
                    context.method_35720(this.field_22793, powerDescriptionLine, x + 2, y, 0xCCCCCC);
                }
                y += 20;
            }
        }
        this.currentMaxScroll = Math.max(0, (y += this.scrollPos) - 14 - (this.guiTop + 158));
    }

    protected final Collection<? extends Power> getSelfOrSubPowers(Power power, Predicate<Power> selfPredicate) {
        if (!selfPredicate.test(power) && power instanceof MultiplePower) {
            MultiplePower multiplePower = (MultiplePower)power;
            return multiplePower.getSubPowers();
        }
        return Set.of(power);
    }

    protected class RenderedBadge {
        private final Power power;
        private final Badge badge;
        private final int x;
        private final int y;

        public RenderedBadge(Power power, Badge badge, int x, int y) {
            this.power = power;
            this.badge = badge;
            this.x = x;
            this.y = y;
        }

        public List<class_5684> getTooltipComponents(class_327 textRenderer, int widthLimit) {
            return this.badge.getTooltipComponents(this.power, widthLimit, OriginDisplayScreen.this.time, textRenderer);
        }

        public boolean hasTooltip() {
            return this.badge.hasTooltip();
        }
    }
}

